################################################################################
# FINLEY STUDENT DEER - V2 CHARISMA MINIGAME
################################################################################

init 2 python:
    # Create Finley's charisma minigame data using the new V2 system
    finley_v2_data = CruisingPassenger(
        npc=finley,
        background="bg regional_jet",
        
        # Introduction sequence
        intro=[
            cruising_narration("You notice a young deer man sitting alone at the back of the plane. He seems fidgety, with his hooves tapping nervously against the floor."),
            cruising_narration("You approach the young deer, who looks up at you with those big brown eyes.")
        ],
        
        # All interactions
        interactions=[
            # First interaction - initial approach
            cruising_interaction(
                question="How would you like to approach Finley?",
                choices=[
                    cruising_choice(
                        text="Professional and polite: 'Is everything alright, sir?'",
                        value="polite",
                        satisfaction=-10,
                        response="Oh, um, yes... thank you. I'm fine.",
                        narration_text="He seems a bit put off by your formal tone."
                    ),
                    cruising_choice(
                        text="Friendly and casual: 'Mind if I join you for a bit?'",
                        value="casual",
                        satisfaction=10,
                        response="Not at all!",
                        narration_text="He seems to appreciate your casual approach."
                    ),
                    cruising_choice(
                        text="Reassuring: 'First time flying can be nerve-wracking, but you're in good hands.'",
                        value="reassure",
                        satisfaction=5,
                        response="Is it that obvious? Yeah, first time... trying not to freak out.",
                        narration_text="He appears slightly calmed by your understanding approach."
                    ),
                    cruising_choice(
                        text="Flirtatious: 'Hey there, cutie. First time flying?'",
                        value="flirt",
                        charisma=3,
                        satisfaction=15,
                        response="That obvious, huh? Yeah, I'm a little nervous.",
                        narration_text="He blushes slightly at your comment, clearly appreciating the attention.",
                        fallback_change=-15,
                        fallback_response="Um, yeah... it is.",
                        fallback_narration="He seems uncomfortable with your forward approach, shifting away slightly."
                    )
                ]
            ),
            
            # Second interaction - discussing nervousness
            cruising_interaction(
                question="How do you respond to his nervousness?",
                choices=[
                    cruising_choice(
                        text="Offer reassurance with statistics: 'Flying is completely safe, the statistics show...'",
                        value="stats",
                        satisfaction=-10,
                        response="Right... statistics. That's... comforting.",
                        narration_text="He doesn't seem particularly reassured by facts and figures."
                    ),
                    cruising_choice(
                        text="Share personal experience: 'I remember my first flight too, it gets easier.'",
                        value="personal",
                        satisfaction=15,
                        response="Really? That's good to hear. How many flights have you been on now?",
                        narration_text="He seems genuinely interested in your experience, his posture relaxing slightly."
                    ),
                    cruising_choice(
                        text="Distract with questions: 'What brings you on this flight today?'",
                        value="distract",
                        satisfaction=5,
                        response="Oh, I'm heading to visit my cousin. He's getting married this weekend.",
                        narration_text="The distraction works, his nervous fidgeting decreasing as he focuses on conversation."
                    ),
                    cruising_choice(
                        text="Physical comfort: Lightly touch his arm while smiling",
                        value="touch",
                        charisma=2,
                        satisfaction=10,
                        response="Thanks, that's actually... really nice of you.",
                        narration_text="He relaxes slightly at your touch, giving you a grateful smile.",
                        fallback_change=-10,
                        fallback_response="Um... I'm okay, thanks.",
                        fallback_narration="He tenses slightly at the unexpected contact, shifting away in his seat."
                    )
                ]
            ),
            
            # Third interaction - conversation topics
            cruising_interaction(
                question="What would you like to talk about?",
                choices=[
                    cruising_choice(
                        text="Ask about his college experience",
                        value="college",
                        satisfaction=15,
                        response="Oh! I'm studying environmental science. It's my first year, but I'm loving it so far.",
                        narration_text="His eyes light up as he talks about his classes and campus life."
                    ),
                    cruising_choice(
                        text="Comment on the flight service",
                        value="service",
                        satisfaction=-10,
                        response="Yeah, everything seems fine I guess.",
                        narration_text="He doesn't seem very interested in discussing the flight."
                    ),
                    cruising_choice(
                        text="Share a funny flight story",
                        value="story",
                        satisfaction=5,
                        response="Heh, that's pretty funny. Nothing like that has happened to me... yet.",
                        narration_text="He smiles, seeming a bit more at ease."
                    ),
                    cruising_choice(
                        text="Compliment his appearance: 'You have beautiful eyes.'",
                        value="compliment",
                        charisma=3,
                        satisfaction=10,
                        response="Oh! That's... wow, thank you. No one's ever said that before.",
                        narration_text="A deep blush spreads across his face, almost to his antlers.",
                        fallback_change=-10,
                        fallback_response="Um, thanks? That's kind of random.",
                        fallback_narration="He seems caught off guard and uncomfortable with the personal comment."
                    )
                ]
            ),
            
            # Fourth interaction - turbulence moment
            cruising_interaction(
                setup=[
                    cruising_narration("The plane hits some turbulence, and Finley instinctively grabs your thigh.")
                ],
                question="How do you react to his touch?",
                choices=[
                    cruising_choice(
                        text="Reassure him calmly: 'It's just a little turbulence, totally normal.'",
                        value="reassure",
                        satisfaction=5,
                        response="R-right, of course. Sorry about grabbing you.",
                        narration_text="He withdraws his hand quickly, looking embarrassed."
                    ),
                    cruising_choice(
                        text="Joke about it: 'Usually I prefer dinner before getting this friendly.'",
                        value="joke",
                        satisfaction=-5,
                        response="I'm so sorry! I didn't mean to... that was inappropriate of me.",
                        narration_text="His ears flatten against his head in embarrassment. Your joke seems to have made him more self-conscious."
                    ),
                    cruising_choice(
                        text="Place your hand over his: 'It's okay, I got you.'",
                        value="hold",
                        satisfaction=15,
                        response="Thanks... that actually helps.",
                        narration_text="His breath catches, and you feel his fingers curl slightly under yours."
                    ),
                    cruising_choice(
                        text="Take the opportunity to move closer to him",
                        value="move",
                        charisma=4,
                        satisfaction=20,
                        response="Oh... um... this is nice.",
                        narration_text="As you shift closer, your thighs press together. A visible blush creeps up his neck.",
                        fallback_change=-15,
                        fallback_response="I should probably try to get some rest now.",
                        fallback_narration="He stiffens slightly at your sudden closeness. He looks uncomfortable with your advance."
                    )
                ]
            ),
            
            # Fifth interaction - final move
            cruising_interaction(
                question="Make your final move:",
                choices=[
                    cruising_choice(
                        text="Suggest helping him relax: 'Maybe there's something I could do to help you relax.'",
                        value="help",
                        satisfaction=10,
                        response="I'd... like that.",
                        narration_text="His eyes widen slightly, and you can see him considering your words."
                    ),
                    cruising_choice(
                        text="Offer a distraction: 'Would you like me to bring you something to drink?'",
                        value="drink",
                        satisfaction=0,
                        response="Some water would be nice, actually.",
                        narration_text="He seems appreciative but the moment's intimacy is lost."
                    ),
                    cruising_choice(
                        text="Be direct about your attraction: 'I find you really attractive, Finley.'",
                        value="direct",
                        charisma=3,
                        satisfaction=15,
                        response="I think you're pretty attractive too... for a human.",
                        narration_text="A shy smile spreads across his face.",
                        fallback_change=-15,
                        fallback_response="Oh! Um, thanks, I guess.",
                        fallback_narration="He seems caught off guard by your directness. He looks around nervously, clearly uncomfortable."
                    ),
                    cruising_choice(
                        text="Whisper something suggestive in his ear",
                        value="whisper",
                        charisma=5,
                        satisfaction=25,
                        response="God, yes. I want that too.",
                        narration_text="His entire body shivers as your breath tickles his ear, and he turns to you with undisguised desire.",
                        fallback_change=-20,
                        fallback_response="I don't think that's appropriate.",
                        fallback_narration="He pulls back, looking uncomfortable. He shifts away from you, clearly wanting to end the interaction."
                    )
                ]
            )
        ],
        
        # Ending labels
        endings={
            "decline": "finley_student_deer_decline",
            "oral": "finley_student_deer_oral_ending",
            "anal": "finley_student_deer_anal_ending"
        }
    )
    
    # Set the V2 data on the Finley NPC
    finley.cruising_v2_data = finley_v2_data

# Scene label to use the new system
label finley_student_deer_v2:
    scene bg regional_jet with fade

    $ finley.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)

    # Launch the V2 charisma minigame
    $ outcome = renpy.call_in_new_context("cruising_minigame_2_v2", "finley")
    
    return

# Keep the existing ending labels unchanged
# (finley_student_deer_decline, finley_student_deer_oral_ending, and finley_student_deer_anal_ending 
#  should be defined elsewhere or will need to be created) 