# prologue.rpy - Updated Version

# Custom transitions for exhaustion/hallucination effects
transform eye_blink:
    alpha 1.0
    linear 0.1 alpha 0.0  # Close eyes
    pause 0.05
    linear 0.1 alpha 1.0  # Open eyes

# Eye blink sequence that repeats
transform blink_sequence(times=3):
    alpha 1.0
    block:
        linear 0.08 alpha 0.0  # Close eyes faster
        pause 0.05
        linear 0.08 alpha 1.0  # Open eyes
        pause 0.2  # Brief pause between blinks
        repeat times

# Slower, more exhausted blink sequence
transform slow_blink_sequence(times=3):
    alpha 1.0
    block:
        linear 0.2 alpha 0.0  # Slowly close eyes
        pause 0.1
        linear 0.2 alpha 1.0  # Slowly open eyes
        pause 0.3  # Longer pause between blinks
        repeat times

# Pixelate dissolve effect
define pixelate_dissolve = MultipleTransition([
    False, Pixellate(0.1, 32),  # Start clear, quickly pixelate
    True, Pause(0.2),  # Hold pixelated
    True, Pixellate(0.3, 1),  # Slowly unpixelate
    True])

# Exhaustion vision blur
transform vision_blur:
    blur 0
    linear 0.3 blur 20
    pause 0.1
    linear 0.3 blur 0

# Alternative blink effect using the actual images
transform hallucination_blink(img_real, img_hallucination):
    img_hallucination
    pause 0.3
    img_real
    pause 0.1
    img_hallucination
    pause 0.2
    img_real
    pause 0.1
    img_hallucination
    pause 0.1
    img_real

# Eye flutter effect - more subtle
transform eye_flutter:
    alpha 1.0
    block:
        linear 0.05 alpha 0.7  # Partial close
        linear 0.05 alpha 1.0  # Open
        pause 0.1
        repeat 4

label prologue_v2:
    scene bg campus_exterior_human with fade
    pause 0.5
    
    "The weight of another semester finally lifts from your shoulders as you step out of the examination hall."
    "You can barely keep your eyes open. Four months of late nights, endless coffee, and desperate cramming sessions have taken their toll."
    "The past week alone, you've gotten maybe twelve hours of sleep total. Your body is running on fumes and sheer willpower."
    "Your phone buzzes with a notification from your rideshare app. Your driver is arriving. You blink hard, trying to focus on the screen."
    
    scene bg rideshare_interior_human
    
    "You slump into the backseat, your backpack light with only your laptop and a few changes of clothes."
    
    driver "Hey there! Just need to confirm, you're my airport pickup, right?"
    
    "The driver glances at their phone mounted on the dashboard."
    
    driver "What's the name on the booking?"
    
    $ mc.name = renpy.input("What is your name?", length=24)
    $ mc.name = mc.name.strip()
    if not mc.name:
        $ mc.name = "River"
    
    mc.name "It's [mc.name]."
    
    driver "Perfect! [mc.name] to Terminal 3, got it. Long flight ahead?"
    
    "The city blurs past the window as exhaustion settles in. Just a few more hours until you're home."
    
    mc.name "Not too bad. Pretty short actually. Heading home for break. Can't wait to sleep in a real bed."
    driver "I bet! College student?"
    mc.name "Yeah, just finished finals."
    driver "Going somewhere nice for break?"
    
    menu:
        driver "Going somewhere nice for break?"
        "\"Finally heading home! Can't wait to see family and eat real food again.\"":
            $ mc.assertiveness += 1
            mc.name "Finally heading home! Can't wait to see family and eat real food again. Dorm cuisine gets old fast."
            driver "Ha! I remember those days. Nothing beats a home-cooked meal."
        
        "\"Just... just home. Sorry, I'm really tired...\"":
            $ mc.submissiveness += 1
            mc.name "Just... just home. Sorry, I'm really tired. Need to sleep for about a week straight."
            driver "I hear you. Finals week is rough."
        
        "\"Going to my parents' house. The Wi-Fi is slow but the food is free!\"":
            $ mc.humor += 1
            mc.name "Going to my parents' house. The Wi-Fi is slow but the food is free!"
            driver "Haha! Best deal in town, right?"
        
        "\"Nowhere as exciting as I'd like... unless you have any recommendations?\"":
            $ mc.flirtiness += 1
            mc.name "Nowhere as exciting as I'd like... unless you have any recommendations?"
            driver "Well, I mostly just drive to the airport these days!"
    
    "The driver chuckles and continues to drive down the highway."
    
    scene bg check_in_counter_human with fade
    
    "The airport bustles with the usual chaos of summer travelers: families with overstuffed luggage, business travelers glued to their phones, and fellow students escaping campus life."
    "You stumble through the sliding doors and into the air-conditioned terminal. The harsh fluorescent lights make you squint."
    

    
    "The check-in line moves at a glacial pace. You shift your weight from foot to foot, fighting to keep your eyes open."
    "Your eyelids flutter closed as you sway on your feet..."
    
    scene bg dream_forest with fade
    
    "The familiar warmth of the dream washes over you. This place again."
    "All through finals week, every time you've managed to steal a few hours of sleep, you've found yourself here."
    "A sunlit forest clearing surrounds you, emerald grass tickling your bare feet. Golden rays filter through a canopy of vibrant leaves."
    "The air carries that same heady mixture of earth, wildflowers, and something else... something musky and primal."
    "You know what comes next. Your pulse quickens with anticipation."
    "Something moves in the shadows between the trees, catching your eye. Large muscular creatures with powerful, furred bodies that have become increasingly familiar with each dream."
    "In previous dreams, they've emerged fully from the trees, magnificent beasts walking upright, their eyes burning with intelligent desire."
    "Lions, tigers, and bears... all manner of creatures who've taken you in ways that left you to wake up achingly hard and in need of a cold shower."
    "Your body responds to the blurred memories, heat pooling in your groin as you wait for them to emerge again from the trees."
    "You hear someone clear their throat loudly behind you."
    
    scene bg check_in_counter_human
    
    
    "You jerk awake, realizing you've been sleeping standing up. The line has moved forward without you."
    "Your face burns with embarrassment. Both from holding up the line and from the very obvious tent in your pants."
    "You quickly adjust yourself and shuffle forward to close the gap, the vivid dream already fading but leaving you frustratingly aroused."
    "Finally, after what feels like hours, you reach the counter where a cheerful airline employee greets you."
    
    "Check-in Employee" "Good afternoon! Where are we heading today?"
    
    menu:
        "Check-in Employee" "Good afternoon! Where are we heading today?"
        "\"Just trying to get home. Here's my confirmation.\"":
            $ mc.assertiveness += 1
            mc.name "Just trying to get home. Here's my confirmation."
            "Check-in Employee" "Straight to business, I like that!"
        
        "\"Home, finally. Sorry if I seem out of it...\"":
            $ mc.submissiveness += 1
            mc.name "Home, finally. Sorry if I seem out of it. Finals week and I'm barely functioning..."
            "Check-in Employee" "Oh honey, I can tell! You look exhausted."
        
        "\"To my bed, hopefully! But I'll settle for my hometown to start.\"":
            $ mc.humor += 1
            mc.name "To my bed, hopefully! But I'll settle for my hometown to start."
            "Check-in Employee" "Ha! I've heard that one a few times today!"
        
        "\"Wherever this airline's excellent service takes me!\"":
            $ mc.flirtiness += 1
            mc.name "Wherever this airline's excellent service takes me! But specifically, home."
            "Check-in Employee" "Oh my, what a charmer! Let's get you checked in."
    
    "You hand over your phone with the booking details."
    
    "Check-in Employee" "Perfect! I'll just need to see your ID, and we'll get you checked in."
    
    "As you dig out your wallet and hand over your driver's license, the employee begins typing."
    
    "Check-in Employee" "Let me pull up your reservation... Ah, there we are, [mc.name]."
    
    "The employee's fingers pause over the keyboard as they glance at their screen."
    
    "Check-in Employee" "I see you're not enrolled in our TailWind loyalty program yet. Would you be interested in signing up? It's free, and you'll earn miles on this flight!"
    
    menu:
        "Check-in Employee" "I see you're not enrolled in our TailWind loyalty program yet. Would you be interested in signing up? It's free, and you'll earn miles on this flight!"
        "\"Yeah, sounds good. Free miles are free miles.\"":
            $ mc.assertiveness += 1
            mc.name "Yeah, sounds good. Free miles are free miles. Let's do it."
            "Check-in Employee" "Excellent choice! Let me just get some quick information."
        
        "\"Um, okay, if you recommend it...\"":
            $ mc.submissiveness += 1
            mc.name "Um, okay, if you recommend it..."
            "Check-in Employee" "You won't regret it! Just need a few details."
        
        "\"Will it get me closer to flying first class?\"":
            $ mc.humor += 1
            mc.name "Will it get me closer to flying first class? Because these student loans aren't paying for that!"
            "Check-in Employee" "Ha! Every mile counts, right? Let's get you started."
        
        "\"If you're the one recommending it, how could I say no?\"":
            $ mc.flirtiness += 1
            mc.name "If you're the one recommending it, how could I say no?"
            "Check-in Employee" "Oh my! Well, let me make sure you get the best signup bonus then."
    
    "Check-in Employee" "First, I'll need to know your occupation. Are you currently a student?"
    mc.name "Yeah, just finished finals actually."
    
    "Check-in Employee" "Wonderful! Here we have a short form to fill out to get to know you better for special promotions."
    
    # This leads into the stat selection
    call screen character_creation
    
    "Check-in Employee" "Excellent! You're all set up. You'll earn double miles on today's flight as a welcome bonus. Any bags to check?"
    
    mc.name "Nope, just my backpack."
    
    "Check-in Employee" "All set then! You're in seat 8A, boarding at Gate 69. Security is just around the corner to your left. Have a great flight on our regional service!"
    
    scene bg airport_security with fade
    pause 0.5
    
    "The security line stretches endlessly before you. You mechanically remove your shoes, empty your pockets, and shuffle forward with the herd."
    "Your eyelids feel like they weigh a thousand pounds. Every few seconds, you catch yourself swaying slightly, nearly falling asleep on your feet."
    "A yawn escapes you, so wide your jaw cracks. The person behind you yawns in response, creating a chain reaction down the line."
    
    scene bg airport_lobby_human with fade
    
    "Finally through security, you reclaim your belongings and check the departure boards. Gate 69 is at the far end of the terminal, naturally."
    "Each step feels like you're walking through molasses. Your brain fog is so thick you have to read the gate number three times to make sure you've got it right."
    "Coffee. You need coffee. Now. Before you collapse right here on the concourse floor."
    
    scene bg airport_coffee_shop with fade
    
    "The coffee shop glows like a holy beacon in your exhausted state. The rich aroma of roasted beans hits you, and you nearly weep with relief."
    "You stumble to the counter, gripping it for support."

    # Show the hallucination with exhaustion blur
    show barista_furry with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    "For a split second, your exhausted brain plays tricks on you. The barista appears to be a massive rhinoceros, thick and muscular with glinting piercings..."
    
    # Slow eye blink effect
    show black:
        alpha 0.0
        slow_blink_sequence(2)
    
    "You blink slowly, trying to focus..."
    
    # Alternate between hallucination and reality with vision blur
    hide barista_furry with dissolve
    show barista with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    
    pause 0.3

    hide barista with dissolve
    show barista_furry with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    
    "The image shifts and wavers..."
    
    # Final transition to reality
    hide black
    hide barista_furry
    show barista:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    $ renpy.with_statement(dissolve)
    
    "...and finally settles into reality as you shake your head."
    "No, it's just a burly guy with gauged ears and a nose ring. Must be the exhaustion."
    
    mc.name "(God, I'm seeing things. I really need this coffee...)"
    
    barista "Whoa there, buddy. You look like you need this. What can I get started for you?"
    
    menu:
        barista "Whoa there, buddy. You look like you need this. What can I get started for you?"
        "\"Large americano, no sugar, extra shot. Maximum caffeine efficiency.\"":
            $ mc.assertiveness += 1
            mc.name "Large americano, no sugar, extra shot. I need maximum caffeine efficiency."
            barista "Someone knows what they want! Coming right up."
        
        "\"Um, whatever has the most caffeine? Sorry, I'm barely functioning...\"":
            $ mc.submissiveness += 1
            mc.name "Um, whatever has the most caffeine? Sorry, I'm barely functioning..."
            barista "Been there, man. I'll hook you up with our strongest cold brew."
        
        "\"I need whatever will make me feel less like a zombie.\"":
            $ mc.humor += 1
            mc.name "I need whatever will make me feel less like a zombie and more like a human."
            barista "Haha! I've got just the thing: our 'Resurrection Roast'!"
        
        "\"What would you recommend for someone who just... stayed up all night?\"":
            $ mc.flirtiness += 1
            mc.name "What would you recommend for someone who just... stayed up all night??"
            barista "Heh, well... our cold brew with espresso cream cold foam is pretty stimulating, if you know what I mean."
    
    "You pay and practically collapse into a small table in the corner, cradling your coffee like a lifeline."
    hide barista with dissolve
    
    "The first sip is heaven. You can actually feel neurons starting to fire again as the caffeine begins its work."
    "As the fog slowly lifts from your brain, you mindlessly scroll through your phone."
    "Your thumb hovers over the familiar orange icon. \"BARQ!\". You've been on there for over a year now, met some interesting people. Had some interesting nights."
    "It's been a while though. Finals killed any chance at a social life, let alone hookups."

    menu:
        "Open BARQ!?"
        "Yeah, let's see who's around":
            $ opened_app = True
            call barq_coffee_shop from _call_barq_coffee_shop
        "Not right now":
            $ opened_app = False
            "You pocket your phone and finish your coffee instead."
            "After draining the last drops, you really need to find a restroom."
    
    # Either path leads to the restroom encounter
    # Branch based on player's previous choices
    
    if not opened_app:
        # Path 1: Didn't open app - walk in on Boris already there
        jump bathroom_no_app
    elif opened_app and not responded_to_boris:
        # Path 2: Opened app, didn't respond - empty bathroom, Boris walks in
        jump bathroom_app_no_respond
    elif opened_app and responded_to_boris and not agreed_to_meet:
        # Path 3: Opened app, responded, didn't meet - empty bathroom, Boris walks in
        jump bathroom_app_respond_no_meet
    else:
        # Path 4: Opened app, responded, agreed to meet - explicit scene
        jump bathroom_app_meet


label bathroom_no_app:
    # Path 1: Didn't open app - walk in on Boris already there
    scene bg airport_bathroom with fade
    
    "You find a restroom near gate 60 and push inside."
    "It's one of those small airport bathrooms. Just a few urinals and stalls."
    
    $ boris.show("nude", at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "You freeze. There's already someone here. A massive guy at the urinal, and he's..."
    "He's not using it. He's standing there with himself fully out, slowly stroking."
    "Built like a literal bear. Dark hair, thick beard, flannel shirt bunched around his waist."
    "The size is... impressive."
    
    $ boris.character.name = "Bear-like Man"
    
    "You can't help but stare. Your eyes are drawn to the motion of his hand."
    "He notices you looking. A slow smile spreads across his face."
    
    boris.character "Like what you see, cutie?"
    
    "You nearly jump. This complete stranger just caught you staring at his hard leaking dick."
    
    menu:
        boris.character "Like what you see, cutie?"
        "\"Maybe. Depends on what you're offering.\"":
            $ mc.assertiveness += 1
            mc.name "Maybe. Depends on what you're offering."
        
        "\"I... um... I wasn't... I mean...\"":
            $ mc.submissiveness += 1
            mc.name "I... um... I wasn't... I mean..."
        
        "\"Well, it's hard to miss when you're advertising like that.\"":
            $ mc.humor += 1
            mc.name "Well, it's hard to miss when you're advertising like that."
        
        "\"Very much so. Question is, do you like what YOU see?\"":
            $ mc.flirtiness += 1
            mc.name "Very much so. Question is, do you like what YOU see?"
    
    "He nods toward the stalls, stroking himself slowly."
    boris.character "Third stall. I'll make it worth your while."
    
    jump bathroom_hallucination_flee
    

label bathroom_app_no_respond:
    # Path 2: Opened app, didn't respond - empty bathroom, Boris walks in
    scene bg airport_bathroom with fade
    
    "You find a restroom near gate 60 and push inside."
    "It's one of those small airport bathrooms. Just a few urinals and stalls."
    "Empty. Thank god. You're too tired to deal with people right now."
    "You step up to a urinal and unzip, finally getting some relief."
    "Your eyes feel so heavy. You could fall asleep standing up."
    
    "The door opens behind you. Heavy footsteps approach."
    "Someone takes the urinal right next to yours. Weird choice when the others are free."
    
    $ boris.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "Out of the corner of your eye, you see he's massive. Built like a literal bear."
    "Dark hair with a flannel shirt stretched across broad shoulders."
    "Wait... is this the guy from the coffee shop? The one who messaged you?"
    
    $ boris.character.name = "Bear-like Man"
    
    "He glances at you, then does a double-take. Recognition flickers in his eyes."
    "He's just using the urinal normally, but he keeps glancing at you with a curious expression."
    
    boris.character "You okay there? You look like you're about to pass out."
    
    
    jump bathroom_concern_hallucination
    

label bathroom_app_respond_no_meet:
    # Path 3: Opened app, responded, didn't meet - empty bathroom, Boris walks in
    scene bg airport_bathroom with fade
    
    "You find a restroom near gate 60 and push inside."
    "It's one of those small airport bathrooms. Just a few urinals and stalls."
    "Empty. Good. You need a moment to yourself after that weird BARQ! interaction."
    "You step up to a urinal and unzip, finally getting some relief."
    "Your exhaustion hits you in waves. Everything feels slightly unreal."
    
    "The door opens behind you. Heavy footsteps approach."
    "Someone takes the urinal right next to yours."
    
    $ boris.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "It's him. The guy from the coffee shop. The one you were messaging with."
    "He recognizes you immediately. A flicker of disappointment crosses his face. You turned him down, after all."
    
    $ boris.character.name = "Bear-like Man"
    
    "He's just using the urinal normally. You do your best to ignore his gaze, but he keeps glancing at you with concern."
    
    boris.character "Hey... you're the guy from BARQ!, right? You really don't look good. Are you feeling alright?"
    
    "His tone is worried, and he seems genuinely concerned about your wellbeing."
    
    jump bathroom_concern_hallucination


label bathroom_app_meet:
    # Path 4: Opened app, responded, agreed to meet - explicit scene
    scene bg airport_bathroom with fade
    
    "You find a restroom near gate 60 and push inside."
    "It's one of those small airport bathrooms. Just a few urinals and stalls."
    "You step up to a urinal and unzip, finally getting some relief."
    
    "The door opens behind you. Heavy footsteps approach."
    "Someone takes the urinal right next to yours. You know who it is before you even look."
    
    $ boris.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "It's the guy from the coffee shop that you were messaging with on BARQ!."
    "He followed you here quickly. Eager."
    "He's not even pretending to use the urinal. Just standing there, rubbing the obvious bulge in his jeans."
    
    $ boris.character.name = "Bear-like Man"
    
    $ boris.hide(with_transition=dissolve)
    $ boris.show("nude", at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "Without any hesitation, he unzips and pulls himself out."
    "The size is... impressive."
    
    boris.character "Like what you see, cutie?"
    
    menu:
        boris.character "Like what you see, cutie?"
        "\"You're not so bad yourself. Living up to the bear emoji.\"":
            $ mc.assertiveness += 1
            mc.name "You're not so bad yourself. Living up to the bear emoji."
        
        "\"Oh, um.... I think so... You're... bigger than I expected.\"":
            $ mc.submissiveness += 1
            mc.name "Oh, um.... I think so... You're... bigger than I expected."
        
        "\"And you're exactly as subtle as your messages suggested.\"":
            $ mc.humor += 1
            mc.name "And you're exactly as subtle as your messages suggested."
        
        "\"I mean who doesn't appreciate a nice cock?\"":
            $ mc.flirtiness += 1
            mc.name "I mean who doesn't appreciate a nice cock?"
    
    "He nods toward the stalls, stroking himself slowly."
    boris.character "Third stall. I'll make it worth your while."
    
    jump bathroom_hallucination_flee


label bathroom_concern_hallucination:
    # Paths 2 and 3: Boris shows concern, hallucination happens while he's just standing there
    
    "As you stare at him, trying to focus through your exhaustion, your vision starts to blur."
    
    # Hide the current boris display to show the hallucination
    $ boris.hide(with_transition=None)
    
    # Show the human version with exhaustion blur
    show boris with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    "The fluorescent lights flicker overhead. Your exhausted mind struggles to process what you're seeing..."
    
    # Slow eye blink effect
    show black:
        alpha 0.0
        slow_blink_sequence(2)
    
    "You blink slowly, but the image refuses to stay stable..."
    
    # Alternate between human and furry with vision blur
    hide boris with dissolve
    show boris_furry with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    pause 0.3

    hide boris_furry with dissolve
    show boris with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    "Is that... fur? No, it can't be. You shake your head, but the shifting continues..."
    
    # Final transition to furry reality
    hide black
    hide boris
    show boris_furry:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    $ renpy.with_statement(dissolve)
    
    "...and when your vision finally clears, you're staring at a massive grizzly bear, standing upright at the urinal."
    
    mc.name "(What the hell? Am I... am I actually seeing this? He's a... bear?)"
    
    boris.character "Whoa, buddy! You don't look—"
    
    "You stumble backward, your vision spinning."
    "Need air. Need to get out."
    
    hide boris_furry with dissolve
    
    "You zip up frantically and bolt from the restroom."
    "You hear him call after you, but you're already gone."
    
    jump prologue_final_boarding


label bathroom_hallucination_flee:
    # Paths 1 and 4: Explicit scene, hallucination of nude Boris
    
    "As you stare, mesmerized by him stroking his massive length, your vision starts to blur."
    
    # Hide the current boris display to show the hallucination
    $ boris.hide(with_transition=None)
    
    # Show the human version with exhaustion blur
    show boris_nude with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    "The fluorescent lights flicker overhead. Your exhausted mind struggles to process what you're seeing..."
    
    # Slow eye blink effect
    show black:
        alpha 0.0
        slow_blink_sequence(2)
    
    "You blink slowly, but the image refuses to stay stable..."
    
    # Alternate between human and furry with vision blur
    hide boris_nude with dissolve
    show boris_furry_nude with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    pause 0.3

    hide boris_furry_nude with dissolve
    show boris_nude with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    "Is that... fur? No, it can't be. You shake your head, but the shifting continues..."
    
    # Final transition to furry reality
    hide black
    hide boris_nude
    show boris_furry_nude:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    $ renpy.with_statement(dissolve)
    
    "...and when your vision finally clears, you're staring at a massive grizzly bear, standing upright, his impressive ursine anatomy on full display."
    
    mc.name "(What the hell? Am I... am I actually seeing this? He's a... bear?)"
    
    "You stumble backward, your vision spinning."
    "Need air. Need to get out."

    hide boris_furry_nude with dissolve
    
    "You zip up frantically and bolt from the restroom."

    jump prologue_final_boarding




label barq_coffee_shop:

    show phone_barq_home at Transform(xpos=0.3, ypos=0.48, xanchor=0.5, yanchor=0.5, zoom=0.78) with dissolve

    "The app loads up with its familiar orange and white interface. A single profile pops up nearby, the rest seem to be back in the city."
    show phone_barq_home_2 at Transform(xpos=0.3, ypos=0.48, xanchor=0.5, yanchor=0.5, zoom=0.78)
    "A notification bubble appears. New message."
    "The profile just shows 🐻 as the username. No photo. Distance shows 0 feet away."
    
    $ boris.character.name = "🐻"
    
    boris.character "Hey there. Traveling alone?"
    
    menu:
        "Respond to the message?"
        "Sure, see where this goes":
            $ responded_to_boris = True
            mc.name "Yeah, heading home. You?"
            boris.character "Just hanging out. You're cute."
            boris.character "Coffee shop, corner table if you want to see who's messaging {plain}😉{/plain}"
            
            # Boris flicker scene - hallucination effect
            "You glance toward the corner."
            
            # Show the human version with exhaustion blur
            show boris with dissolve:
                zoom 0.8
                xpos 0.7
                ypos 0.6
                xanchor 0.5
                yanchor 0.5
                vision_blur
            
            "There's a massive guy in flannel sitting there. He gives you a small wave."
            "Your exhausted eyes struggle to focus..."
            
            # Slow eye blink effect
            show black:
                alpha 0.0
                slow_blink_sequence(2)
            
            "You blink hard, but something's not right..."
            
            # Alternate between human and furry with vision blur
            hide boris with dissolve
            show boris_furry with dissolve:
                zoom 0.8
                xpos 0.7
                ypos 0.6
                xanchor 0.5
                yanchor 0.5
                vision_blur
            
            "For a moment, that's not a man. That's a bear. An actual grizzly bear in flannel."
            
            pause 0.3
            
            hide boris_furry with dissolve
            show boris with dissolve:
                zoom 0.8
                xpos 0.7
                ypos 0.6
                xanchor 0.5
                yanchor 0.5
                vision_blur
            
            "The image flickers back. Just a big hairy guy. Right?"
            
            pause 0.2
            
            hide boris with dissolve
            show boris_furry with dissolve:
                zoom 0.8
                xpos 0.7
                ypos 0.6
                xanchor 0.5
                yanchor 0.5
                vision_blur
            
            "No, definitely a bear. Those are definitely paws holding that phone..."
            
            # Final transition back to human reality
            hide black
            hide boris_furry
            show boris:
                zoom 0.8
                xpos 0.7
                ypos 0.6
                xanchor 0.5
                yanchor 0.5
                vision_blur
            $ renpy.with_statement(dissolve)
            
            "You rub your eyes hard. When you look again, it's just a man. A very large, bear-like man, but definitely human."
            "Definitely need sleep."
            
            boris.character "Like what you see?"
            boris.character "I know a quiet spot if you want to hang out."
            
            menu:
                "Meet up with the BARQ! guy?"
                "Why not":
                    $ agreed_to_meet = True
                    mc.name "Sure. Where?"
                    boris.character "Bathroom by gate 60. I'll find you {plain}😈{/plain}"
                    "Public bathroom... Of course. Hot but kinda risky..."
                "Pass":
                    $ agreed_to_meet = False
                    mc.name "Maybe another time. Got a flight soon."
                    boris.character "Your loss, cub."
            
            $ boris.hide()
            hide phone_barq_home_2
            hide phone_barq_home
            $ renpy.with_statement(dissolve)
            
        "Nah, close the app":
            $ responded_to_boris = False
            "You close BARQ! without responding."
            "Anonymous profiles are always a gamble anyway."
    
    "You finish your coffee. Time to find that restroom."
    return





label prologue_final_boarding:

    scene bg airport_lobby_human with fade

    "You lean against the wall outside, chest heaving."
    "What the fuck was that? Are you losing your mind?"
    "Your hands won't stop shaking. That was a bear. An actual bear. But also a man. But also..."
    "You pat your pockets frantically. Phone, wallet..."
    "Shit. Shit shit shit. Your boarding pass."
    "You must have dropped it in there. But there's no way you're going back. No fucking way."
    "Maybe you can get a reprint at the gate. Maybe you can just explain that you..."

    # Boris appears and taps shoulder
    "A hand taps your shoulder."
    boris.character "Hey."

    "You practically jump out of your skin, spinning around with a strangled yelp."

    $ boris.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)

    "It's him. Fully dressed. Completely human. Completely normal."
    "Like nothing happened."

    boris.character "Easy there, cub. You dropped this."

    "He holds out your boarding pass. You stare at it like it might bite you."

    boris.character "By the sink. You really bolted out of there."

    "You snatch it from his hand, taking a step back."
    mc.name "Th-Thanks..."

    "Your voice cracks. You clear your throat."
    mc.name "I mean. Thank you. I'm just... tired."

    boris.character "I can tell."

    "He smiles. There's something knowing in it."

    boris.character "See you around, human."

    "You barely register his words. You're too busy trying to process what just happened."
    "He turns and walks away. His shadow stretches long across the floor."

    $ boris.hide(with_transition=dissolve)

    
    scene bg gate_69 with fade
    
    "After your restroom adventure, you finally make your way to Gate 69."
    "The gate area is practically deserted. Only a handful of passengers sit scattered across the rows of seats."
    "You're not really surprised. The regional jet to your tiny hometown airport never fills up. Most people drive the six hours rather than deal with the airport."
    "You easily find a seat by yourself and slump into it, exhaustion washing over you."
    
    
    "The coffee made a valiant effort, but your eyes grow heavy as you wait for boarding. Just a quick rest..."
    
    scene bg dream_forest with fade
    
    "You're back in that strange forest clearing. The light is different now, more golden, more intense."
    "This time, you see what emerges from the trees."
    
    if opened_app:
        "It's the man from the coffee shop, but... changed. No longer human, he stands as a magnificent brown bear, his powerful form covered in thick, glossy fur."
        "Those same dark eyes that watched you in the coffee shop now gleam with animal intensity."
    else:
        "A figure emerges from the shadows. Massive, powerful, covered in brown fur. A bear that walks like a man."
        "Something about him feels familiar, though you can't place why."
    
    "Your breath catches as amber eyes lock with yours. He moves toward you with predatory grace."
    "As he approaches, you notice more movement at the treeline. Other figures, waiting, watching..."
    "A flash of orange stripes. The glint of metal piercings. A blonde mane catching the light. They seem almost... familiar?"
    "The bear reaches out one massive paw toward you, and you find yourself reaching back..."
    
    scene bg gate_69
    
    "An announcement crackles over the intercom, startling you awake."
    "You look toward the gate desk and see the agent making the announcement."
    
    # Show the hallucination with exhaustion blur
    show gateagent_furry with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    "Your post-nap grogginess hits hard. The figure at the podium seems to shimmer, sleek orange fur with black stripes, a long tail swishing behind the desk as they speak into the microphone..."
    
    # Slow eye blink effect
    show black:
        alpha 0.0
        slow_blink_sequence(2)
    
    "You squeeze your eyes shut, trying to shake off the lingering dream..."
    
    # Alternate between hallucination and reality with vision blur
    hide gateagent_furry with dissolve
    show gateagent with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    pause 0.3

    hide gateagent with dissolve
    show gateagent_furry with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    "Reality refuses to stabilize, flickering between human and beast..."
    
    # Final transition to reality
    hide black
    hide gateagent_furry
    show gateagent:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    $ renpy.with_statement(dissolve)
    
    "...until the world finally snaps back into focus."
    "Just an airline employee with artfully streaked hair. Those stripes in their dyed hair... was that what triggered the hallucination?"
    
    mc.name "(What is wrong with me? First the rhino barista, then the bear in the bathroom, now a tiger? I need to get some real sleep...)"
    
    gate_agent "Good afternoon, passengers. This is a pre-boarding announcement for Flight 369, our regional service to..."
    
    "The destination gets lost in static. Strange, but you're too tired to care. You know where you're going anyway."
    "Your heart is still racing from the vivid dream. What was that about?"
    
    gate_agent "Due to the small size of this aircraft, we'll be boarding all passengers together in just a few moments."
    
    scene bg regional_jet with fade
    
    "The boarding process is quick with so few passengers. You follow the small group down the jet bridge, your exhaustion making everything feel slightly surreal."
    
    "As you approach the aircraft door, you see the flight attendant greeting passengers."
    
    # Show the hallucination with exhaustion blur
    show fa_furry with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    "Standing in the doorway is a golden stallion in uniform, his powerful frame filling the entrance, blonde mane perfectly groomed..."
    
    # Slow eye blink effect
    show black:
        alpha 0.0
        slow_blink_sequence(2)
    
    "Your knees buckle slightly. The metal threshold catches your shoe..."
    
    # Alternate between hallucination and reality with vision blur
    hide fa_furry with dissolve
    show fa with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    pause 0.3

    hide fa with dissolve
    show fa_furry with dissolve:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    
    "Man? Horse? Your exhausted mind can't decide which is real..."
    
    # Final transition to reality
    hide black
    hide fa_furry
    show fa:
        zoom 0.8
        xpos 0.5
        ypos 0.6
        xanchor 0.5
        yanchor 0.5
        vision_blur
    $ renpy.with_statement(dissolve)
    
    "...until you grab the doorframe and force yourself to focus."
    "Human. Definitely human. Athletic build, long blonde hair in a neat ponytail. Though something about his stance, proud and tall..."
    
    mc.name "(A horse now? What's next, the pilot's going to be a wolf? I'm losing it...)"
    
    flight_attendant "Welcome aboard! Seat 8A is just a few rows back on your right. Plenty of room to spread out this afternoon."
    
    hide fa with dissolve

    "You find your seat and stuff your backpack into the overhead bin. The entire row is yours, a benefit of being on a half-empty regional jet."
    "As you buckle in, you notice something odd. The safety card in the seat pocket seems to have unusual illustrations, but your tired eyes can't quite make them out."
    "The few other passengers settling in seem strangely indistinct, like figures in a dream. Must be the exhaustion playing tricks on you."
    
    "Captain" "Good afternoon, folks. This is your captain speaking. We're expecting a smooth flight this afternoon. Flight time will be... well, we'll get you there when we get you there."
    
    menu:
        "That's an odd announcement. How do you react?"
        "Crane your neck to look around the cabin":
            $ mc.assertiveness += 1
            "You crane your neck to look around the cabin."
            mc.name "Did anyone else hear that? What kind of announcement was that?"
            "The few passengers you can see don't react at all. It's like they didn't even hear it."
        
        "Grip your armrests tighter and stay silent":
            $ mc.submissiveness += 1
            "You grip your armrests a bit tighter."
            "Something feels wrong, but you don't want to make a scene."
            "Maybe you're just being paranoid from exhaustion."
        
        "Chuckle to yourself at the unusual humor":
            $ mc.humor += 1
            "You chuckle to yourself."
            mc.name "Must be a pilot with a sense of humor. Refreshing change from the usual script."
        
        "Smile slightly with intrigue":
            $ mc.flirtiness += 1
            "You smile slightly."
            "How mysterious. This flight is already more interesting than most."
    
    "Your eyelids begin to grow heavy as the engines rumble to life and the plane begins to taxi. The vibration is oddly soothing."
    "As the aircraft lifts off, you surrender to exhaustion, your eyes sliding closed."
    
    scene black with fade
    
    "Sleep takes you immediately."
    "The strange dreams from earlier return with vivid intensity..."
    
    scene bg dream_forest with fade
    
    "You're back in the forest clearing, but this time you're not alone."
    "The bear from your earlier dreams stands before you, closer than ever. His amber eyes burn with unmistakable desire."
    
    "You recognize him now, even in this form. The man from the restroom, transformed into something wild and powerful."
    
    "The other figures have emerged fully from the trees now, and you recognize them with a shock."
    "The tiger with his lithe build and distinctive stripes. The massive rhino with glinting piercings. The muscular horse with his flowing blonde mane."
    "The people from the airport, transformed. Together with the bear, they form a tightening circle around you, their eyes gleaming with shared hunger."
    
    "A delicious tension builds as they close in. Powerful hands and paws begin to explore your body."
    "You're lifted effortlessly, cradled by their collective strength."
    "Your clothes seem to melt away at their touch. They lower you onto soft moss, surrounding you completely."
    
    "You're transfixed by the sight of their powerful chests rising and falling with heavy breaths. Muscles tensing beneath exotic hides, their impressive arousals evident, leaking, and unapologetic."
    "As you reach out to touch one of their leaking cocks, a loud chime permeates the air all around you."
    
    "{b}*DING*{/b}"
    
    "The forest scene flickers, the creatures becoming translucent."
    
    
    return



# Supporting labels for updated prologue