label milehigh_mixer:

    # This file is the flavor text for the bar scenes, as well as the logic for calling the different patron's scenes.

    scene bg mile_high_mixer_night

    "As you step into the bustling airport lounge, the cacophony of murmurs and clinking glasses envelops you. The dim lighting casts a warm, inviting glow across the room."
    "You make your way to the bar, the gleaming wood reflecting the subtle hues of the cocktails being expertly mixed by Grizz, the towering bear of a bartender."
    "His gruff demeanor belies a heart of gold, and he flashes a warm smile as you take a seat."

    # Get the lounge bar location
    $ current_location = lounge_bar
    
    # Get all available NPCs from the bar location
    $ available_npcs = [npc for npc in current_location.NPCs if npc.bar_scene is not None]
    
    # Prioritize unseen NPCs
    $ unseen_npcs = [npc for npc in available_npcs if npc.enCounter == 0]
    
    # Prepare the final list of NPCs to choose from
    $ selection_npcs = []
    $ max_npcs_to_show = 4  # Define max NPCs to show
    
    # First add unseen NPCs
    $ num_unseen_to_add = min(len(unseen_npcs), max_npcs_to_show)
    $ selection_npcs.extend(unseen_npcs[:num_unseen_to_add])
    
    # If we need more, add seen NPCs
    if len(selection_npcs) < max_npcs_to_show:
        $ seen_options = [npc for npc in available_npcs if npc not in selection_npcs]
        $ num_seen_to_add = min(len(seen_options), max_npcs_to_show - len(selection_npcs))
        $ selection_npcs.extend(seen_options[:num_seen_to_add])
    
    # Shuffle the NPCs
    $ random.shuffle(selection_npcs)


    
    if len(selection_npcs) > 0:
        "As you scan the bar, several patrons catch your attention. Who would you like to approach?"
        
        python:
            # Build a menu with all available NPCs
            choices = []
            #for npc in selection_npcs:
                #choices.append((f"{npc.character.name} ({npc.species})", npc))
            choices.append((f"{dash.character.name} ({dash.species})", dash))
            choices.append((f"{chuckles.character.name} ({chuckles.species})", chuckles))

            if grizz.enCounter == 0:
                choices = []
                choices.append((f"{grizz.character.name} ({grizz.species})", grizz))


            choices.append(("Enjoy your drink alone", None))
            
            # Display the menu and get the selected NPC
            selected_npc = renpy.display_menu(choices)
        
        if selected_npc is not None:
            "You decide to approach [selected_npc.character.name]."
            $ renpy.call(selected_npc.bar_scene)
            $ selected_npc.encounter()  # Increment encounter count
            #"Exhausted you return to your makeshift home inside the storage closet. You quickly drift to sleep the memory of the [selected_npc.character.name] still fresh in your mind."
        else:
            "You decide to enjoy your drink in solitude tonight."


            #"Exhausted you return to your makeshift home inside the storage closet. You quickly drift to sleep the memory of the previous shift still fresh in your mind."
    else:
        # Fallback if no valid patron is found
        "The bar seems quieter than usual tonight. You enjoy your drink in peace."


        #"Exhausted you return to your makeshift home inside the storage closet. You quickly drift to sleep the memory of the previous shift still fresh in your mind."
    
    return

