label shower_room_scene:
    # This label is called when the player chooses to take a shower
    # It always tries to provide a sexual encounter with an NPC

    # scene bg storage_home with fade
    
    # "The harsh beeping of your alarm clock pierces the dim light of your storage closet home, dragging you from sleep."
    
    # "You fumble for the source of the noise before finally silencing the device."
    
    # "Rising stiffly to your feet, you stretch your lean frame, working out the kinks from another night spent on your makeshift bed."
    
    # "The storage room is still unfamiliar to your human eyes, a stark reminder that you're in a world not your own - a world where you're the odd one out."
    
    # "You need to get ready for your shift as a flight attendant. A shower is definitely in order."
    
    # "Navigating through the maze of crates and shelves, you make your way out of your storage closet abode, heading toward the lounge restroom and showers."
    
    scene bg lounge_bathroom
    
    "You push open the door to the restroom. Everything feels oversized, built for creatures much larger than yourself."
    
    "You continue through until you're standing outside the door marked 'Locker Room.'"
    
    scene bg lounge_locker_room
    
    "Taking a deep breath, you push through the door and step into the communal locker room, steam filling the space and the air thick with the scent of wet fur and soap."
    
    "You quickly undress, grab a towel nearly large enough to be a bedsheet, and head towards the shower area."
    
    
    # Ensure all location NPC lists are up-to-date
    $ Location.populate_all_locations()

    # Get the shower room location
    $ current_location = shower_room
    
    # Get all NPCs present in this location without modifying the global registry
    $ location_npcs = list(current_location.NPCs)
    
    # Filter NPCs that have a shower scene
    $ available_npcs = [npc for npc in location_npcs if npc.shower_scene is not None]
    
    # Prioritize unseen NPCs
    $ unseen_npcs = [npc for npc in available_npcs if npc.enCounter == 0]
    
    # Initialize shower_patron to None
    $ shower_patron = None
    
    # Add a 50% chance of having an empty shower room
    # WE CAN ADD PERCEPTION HERE LATER
    $ has_encounter = renpy.random.random() < 0.75

    if has_encounter:
        # Check if Balthazar is in the unseen NPCs
        $ balthazar_unseen = [npc for npc in unseen_npcs if npc == balthazar]
        
        if balthazar_unseen:
            # If Balthazar hasn't been encountered, select him
            $ shower_patron = balthazar
        elif unseen_npcs:
            # Otherwise, select a random unseen NPC
            $ random.shuffle(unseen_npcs)
            $ shower_patron = unseen_npcs[0]
        elif available_npcs:
            # If all NPCs have been seen, select a random one
            $ random.shuffle(available_npcs)
            $ shower_patron = available_npcs[0]
    
    if shower_patron is not None:
        # Call the NPC's shower scene
        #"Your eyes meet those of [shower_patron.character.name], a [shower_patron.species] who seems to have been watching you since you entered."
        
        #"There's something in their gaze that sends a shiver down your spine - not fear, but anticipation. You've learned enough about this world to recognize interest when you see it."
        
        $ renpy.call(shower_patron.shower_scene)
        
        # Increment encounter count handling this per file for now
        
        #$ shower_patron.encounter()
        
        #"After your encounter with [shower_patron.character.name], you finish washing up, your body pleasantly sore and your mind replaying what just happened."
        
    else:
        # Fallback if no valid patron is found
        "Strangely, the shower room is empty today. You take advantage of the rare privacy to enjoy a thorough, uninterrupted shower."
        
        "The hot water cascades over your body, washing away tension and leaving you refreshed. It's almost disappointing not to have company, given what usually happens in here."
        
        "Still, the peaceful moment gives you time to reflect on how much you've changed since arriving in this world, how quickly you've adapted to its strange customs and inhabitants."
    

    
    return 