################################################################################
# CHOP REGIONAL JET ENCOUNTER - V2 CHARISMA MINIGAME
################################################################################

init 2 python:
    # Create Chop's charisma minigame data using the new V2 system
    chop_v2_data = CruisingPassenger(
        npc=chop,
        background="bg regional_jet",
        
        # Introduction sequence
        intro=[
            cruising_narration("As you watch the passengers board, your eyes catch sight of a rugged-looking pig in a black leather jacket near the end of the line. He's not particularly handsome, but there's an undeniable air of confidence about him."),
            cruising_narration("His gaze is fixed on you, and you feel a shiver run down your spine as your eyes meet."),
            cruising_dialogue(chop.character, "Well, well, what do we have here? Ain't you just the prettiest little flight attendant I've ever seen."),
            cruising_narration("His gravelly voice carries easily across the boarding area, causing a few heads to turn in your direction.")
        ],
        
        # All interactions
        interactions=[
            # First interaction - initial boarding
            cruising_interaction(
                setup=[
                    cruising_narration("You force a smile and greet him warmly as he boards the plane. He flashes you a sly grin and gives your ass a firm slap, sending a jolt of surprise and arousal through you."),
                    cruising_narration("Winking, he heads toward his seat at the back of the plane, leaving you flustered but intrigued.")
                ],
                question="How do you respond to Chop's boldness?",
                choices=[
                    cruising_choice(
                        text="Professional: Maintain your composure and a neutral expression",
                        value="professional",
                        satisfaction=-10,
                        response="Too professional for your own good, sweetheart.",
                        narration_text="You maintain your professionalism, keeping your expression neutral despite the unexpected contact. He looks back over your shoulder, clearly disappointed by your lack of reaction. His voice carries a note of challenge as he continues to his seat."
                    ),
                    cruising_choice(
                        text="Assertive: 'Sir, that's crossing a line, but I'll let it slide this time.'",
                        value="assertive",
                        satisfaction=5,
                        response="Got some fire in ya. I like that.",
                        narration_text="You keep your voice low but firm, establishing a boundary while showing you're not easily intimidated. He raises an eyebrow, impressed by your directness."
                    ),
                    cruising_choice(
                        text="Playful: Give him a look of mock offense with a hidden smile",
                        value="playful",
                        satisfaction=10,
                        response="Don't worry darlin', there's plenty more where that came from.",
                        narration_text=[
                            "You give him a look of mock offense, but can't quite hide the smile playing at the corners of your mouth. He catches your attempt to look stern and chuckles appreciatively.",
                            "He seems pleased by your ability to play along without making a scene."
                        ]
                    ),
                    cruising_choice(
                        text="Encouraging: Offer a subtle wink as he walks away",
                        value="encourage",
                        charisma=3,
                        satisfaction=15,
                        response="Well now, this flight just got a whole lot more interesting.",
                        narration_text="You glance around quickly to ensure no one is watching, then offer him a subtle wink. His eyes light up with excitement at your encouraging response. There's a new swagger in his step as he heads to his seat, clearly energized by your response.",
                        fallback_change=-5,
                        fallback_response="Might wanna work on that wink, sweetheart.",
                        fallback_narration="Your attempt at a flirtatious wink comes across as awkward and forced. He gives you a confused look before continuing to his seat."
                    )
                ]
            ),
            
            # Second interaction - drink service
            cruising_interaction(
                setup=[
                    cruising_narration("During the drink service, you approach his row. He sprawls comfortably in his seat, legs spread wide, taking up more space than strictly necessary."),
                    cruising_dialogue(chop.character, "Well hello again, gorgeous. Got anything special on that cart for a thirsty pig?"),
                    cruising_narration("His gaze openly roams over your body as he speaks, not bothering to hide his interest.")
                ],
                question="How do you respond to his suggestive question?",
                choices=[
                    cruising_choice(
                        text="Standard service: 'We have water, juice, and soft drinks available today.'",
                        value="standard",
                        satisfaction=-15,
                        response="Boring. Just give me a beer.",
                        narration_text="You recite the standard drink options in a professional tone, ignoring his suggestive undertone. He seems disappointed by your lack of engagement, taking the drink with barely a glance. You notice his attention shifting away from you, interest clearly waning."
                    ),
                    cruising_choice(
                        text="Playful: 'Depends what you're thirsty for.'",
                        value="playful_response",
                        satisfaction=10,
                        response="Oh, I'm thirsty for all sorts of things that ain't on that cart, sugar.",
                        narration_text=[
                            "You deliver the line with just enough suggestion in your voice to be interesting while maintaining plausible deniability.",
                            "He grins broadly, delighted by your willingness to play along. The electricity between you is palpable."
                        ]
                    ),
                    cruising_choice(
                        text="Direct: 'Just the usual drinks, but I might have something special later.'",
                        value="direct",
                        satisfaction=15,
                        response="I'll hold you to that, darlin'. Beer for now, to wet my whistle.",
                        narration_text="You speak quietly enough that only he can hear, maintaining eye contact as you deliver the promise. There's a new heat in his gaze as you hand him his drink, his fingers deliberately brushing against yours."
                    ),
                    cruising_choice(
                        text="Bold: Lean down and whisper something just for him",
                        value="bold",
                        charisma=4,
                        satisfaction=20,
                        response="Fuck, you're somethin' else. Can't wait to see these 'services' of yours.",
                        narration_text="You lean down, your lips nearly brushing his ear. A visible shiver runs through him at your bold promise. His voice has dropped an octave, rough with barely contained desire.",
                        fallback_change=-10,
                        fallback_response="Careful there! Save the wet stuff for later, eh?",
                        fallback_narration="You try to be seductive but lean in too far, nearly spilling drinks on his lap. He jerks back to avoid the potential mess. His joke makes light of your clumsiness, but you can sense his disappointment."
                    )
                ]
            ),
            
            # Third interaction - galley encounter
            cruising_interaction(
                setup=[
                    cruising_narration("The flight proceeds without incident. Exhausted from your long first day, you retreat to the rear galley and buckle yourself into the jump seat for a moment of rest."),
                    cruising_narration("You close your eyes, the steady hum of the engines lulling you into a light doze."),
                    cruising_narration("The sound of the seatbelt sign dinging off jolts you back to awareness, but before you can get up, you hear heavy footsteps approaching."),
                    cruising_narration("You look up to find Chop standing in front of you, his imposing form filling the small galley doorway. There's a predatory gleam in his eyes as he looks you up and down."),
                    cruising_dialogue(chop.character, "Well, well. Look what I found back here all alone."),
                    cruising_narration("He steps into the galley, the space immediately feeling much smaller. You notice he's unzipped his leather jacket, revealing a worn white tank top over his thick build."),
                    cruising_narration("His hand moves to adjust himself through his pants, deliberately drawing your attention to the substantial bulge there.")
                ],
                question="How do you respond to his exhibitionist display?",
                choices=[
                    cruising_choice(
                        text="Nervous: Look away and try to maintain professionalism",
                        value="nervous",
                        satisfaction=-15,
                        response="Not even gonna look, huh? Thought you had more fire in ya.",
                        narration_text=[
                            "You quickly avert your eyes, trying to maintain professionalism despite his obvious display.",
                            "He frowns at your apparent disinterest, disappointment evident in his expression. He begins to button his shirt back up, his eagerness noticeably dimming."
                        ]
                    ),
                    cruising_choice(
                        text="Direct: 'You shouldn't be in the crew area, sir.'",
                        value="direct_response",
                        satisfaction=-5,
                        response="Just wanted to check on my favorite flight attendant. Don't worry, I can play by the rules... when I have to.",
                        narration_text="You meet his gaze directly, avoiding looking at his exposed chest. He raises an eyebrow at your professional tone. There's a challenging edge to his voice as he stands his ground."
                    ),
                    cruising_choice(
                        text="Interested: Allow your gaze to linger on his exposed chest",
                        value="look",
                        satisfaction=15,
                        response="Like what you see, darlin'?",
                        narration_text=[
                            "You allow your gaze to travel slowly over his exposed chest before meeting his eyes again.",
                            "A satisfied smirk spreads across his face as he catches you looking. He deliberately flexes his chest muscles, clearly enjoying your attention.",
                            "You don't answer, but your appreciative gaze speaks volumes."
                        ]
                    ),
                    cruising_choice(
                        text="Encouraging: 'That's quite a view you're offering.'",
                        value="encourage_exhib",
                        charisma=3,
                        satisfaction=20,
                        response="Oh sweetheart, this is just the preview. The main show's much more impressive.",
                        narration_text="You let your eyes roam openly over his display, a small smile playing on your lips. His pupils dilate with excitement at your open encouragement. As if to prove his point, he unbuttons his shirt completely, revealing his entire torso.",
                        fallback_change=-10,
                        fallback_response="Can't tell if you're interested or not, sugar. Mixed signals ain't my thing.",
                        fallback_narration=[
                            "You try to sound encouraging but your delivery is awkward and unnatural.",
                            "He tilts his head, clearly confused by your mixed signals.",
                            "He begins to button his shirt, the moment lost."
                        ]
                    )
                ]
            ),
            
            # Fourth interaction - direct proposition
            cruising_interaction(
                setup=[
                    cruising_narration("Chop moves closer, trapping you in the jump seat with his impressive bulk. The scent of leather and masculine musk surrounds you."),
                    cruising_dialogue(chop.character, "I was hopin' I could get your assistance with a bit of a problem I'm havin'."),
                    cruising_narration("His voice is low and husky. Your eyes flick down instinctively to his crotch, and he chuckles, his hand reaching down to cup the substantial bulge there."),
                    cruising_dialogue(chop.character, "Seems this ol' hog's got a mighty big hard-on, and I reckon it needs some attention.")
                ],
                question="How do you respond to his direct proposition?",
                choices=[
                    cruising_choice(
                        text="Reject: 'I'm sorry, I can't risk my job for this.'",
                        value="reject",
                        satisfaction=-25,
                        response="Your loss, darlin'. Thought you had more adventure in ya.",
                        narration_text="You straighten your posture, mustering a professional tone despite your vulnerable position. His expression darkens momentarily before settling into resignation. He slowly buckles his belt again, the moment between you broken."
                    ),
                    cruising_choice(
                        text="Hesitant: 'Someone might see us here...'",
                        value="hesitant_response",
                        satisfaction=5,
                        response="Don't worry about that, sugar. Everyone's watching the movie, and I can be real quick... or real slow, depending on what you prefer.",
                        narration_text="You glance nervously toward the curtain separating the galley from the cabin. Your response isn't a rejection, just a practical concern, which seems to please him. His voice drops to a seductive rumble on the last words."
                    ),
                    cruising_choice(
                        text="Intrigued: 'That does look like quite a problem.'",
                        value="intrigued",
                        satisfaction=15,
                        response="Ain't it just? Think you might have the solution?",
                        narration_text="You let your gaze linger on his bulge, making no attempt to hide your interest. He groans softly at your response, clearly excited by your willingness to engage. The air between you feels charged with anticipation."
                    ),
                    cruising_choice(
                        text="Bold: Reach out and touch his bulge through his pants",
                        value="touch_bulge",
                        charisma=4,
                        satisfaction=25,
                        response="Fuck, darlin'. You don't waste time, do ya?",
                        narration_text="Without hesitation, you reach out and press your palm against the impressive bulge in his pants. He sucks in a sharp breath, clearly not expecting such boldness from you. The heat of him pulses against your hand, his arousal evident even through the thick material.",
                        fallback_change=-10,
                        fallback_response="Might need to work on your aim there, sweetheart.",
                        fallback_narration="You reach toward his bulge but misjudge the distance, your hand landing awkwardly on his hip instead. He looks down at your hand, then back at your face with a raised eyebrow. You withdraw your hand, the moment's potential fizzling with your awkward execution."
                    )
                ]
            ),
            
            # Fifth interaction - final decision
            cruising_interaction(
                setup=[
                    cruising_narration("Chop steps even closer, the heat of his body radiating against yours. His hand brushes a strand of hair from your face with surprising gentleness."),
                    cruising_dialogue(chop.character, "I saw the way you were lookin' at me. I reckon you'd like to help me out with this."),
                    cruising_narration("His other hand moves to his belt buckle, and you hear the metal clinking as he begins to undo it. His intentions couldn't be clearer as he waits for your response.")
                ],
                question="What's your final decision?",
                choices=[
                    cruising_choice(
                        text="Decline: 'I'm sorry, I can't risk my job for this.'",
                        value="decline",
                        satisfaction=-50,
                        response="Your loss, sweetheart. Plenty of other flight attendants who know how to have a good time.",
                        narration_text="You take a step back as far as the small space allows, shaking your head firmly. Disappointment flashes across his face, followed by resignation. He slowly buckles his belt again, the moment between you broken."
                    ),
                    cruising_choice(
                        text="Hesitant acceptance: 'I suppose I could help... just this once.'",
                        value="hesitant_accept",
                        satisfaction=5,
                        response="That's all I'm askin' for, darlin'. Promise I'll make it worth your while.",
                        narration_text="You hesitate for a moment, weighing desire against professional caution. He grins widely at your acceptance, even if it's reluctant. His fingers continue working at his belt with renewed enthusiasm."
                    ),
                    cruising_choice(
                        text="Eager acceptance: 'I've been hoping for this since you boarded.'",
                        value="eager_accept",
                        satisfaction=15,
                        response="Damn, sugar. You're just full of surprises.",
                        narration_text="A smile of anticipation spreads across your face as you meet his gaze directly. He growls softly with pleasure at your enthusiasm. His hands work more quickly at his belt, eager to make good on the promise between you."
                    ),
                    cruising_choice(
                        text="Take control: Push him against the wall and take charge",
                        value="take_charge",
                        charisma=5,
                        satisfaction=25,
                        response="Fuck yeah. Show me what you got, darlin'.",
                        narration_text=[
                            "In a surprising move, you push him back against the galley wall, taking control of the situation. His eyes widen with shock before darkening with desire at your unexpected boldness.",
                            "A rumble of approval vibrates through his chest. You take over unbuckling his belt, enjoying the way his breathing quickens at your touch."
                        ],
                        fallback_change=-15,
                        fallback_response="Nice try, sweetheart, but I think we both know who's in charge here.",
                        fallback_narration="You try to push him back against the wall, but he barely budges against your insufficient force. He raises an eyebrow at your failed attempt to take control. Your failed power move has somewhat dampened the mood."
                    )
                ]
            )
        ],
        
        # Ending labels
        endings={
            "decline": "chop_regional_1_decline",
            "oral": "chop_oral_ending",
            "anal": "chop_oral_ending"  # Using oral ending for both for now
        }
    )
    
    # Set the V2 data on the Chop NPC
    chop.cruising_v2_data = chop_v2_data

# Updated scene label to use the new system
label chop_regional_1_v2:
    scene bg regional_jet


    
    $ chop.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.63, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)



    # Launch the V2 charisma minigame - it handles the endings internally
    $ outcome = renpy.call_in_new_context("cruising_minigame_2_v2", "chop")
    $ chop.hide()
    
    # The minigame has already played the appropriate ending, so we just return
    return

# Keep the existing ending labels unchanged
# (chop_regional_1_decline and chop_oral_ending are already defined in the original file) 