# The script of the game goes in this file.

# Declare characters used by this game. The color argument colorizes the
# name of the character.

# The action and sexual encounter NPCs, Locations, and Variables are defined in this file.

# NPC Class for defining interactable/fuckable characters.

# Define the placeholder overlay image
image placeholder_overlay = "placeholder_overlay.png"

# Development mode for placeholder art
init python:
    # Development flag - set to False when you have final assets
    config.developer = False
    
    # Store the original scene statement
    _original_scene = renpy.exports.scene
    
    # Override the scene statement
    def _dev_scene(*args, **kwargs):
        # Call the original scene function
        _original_scene(*args, **kwargs)
        
        # If in development mode, apply blur to whatever was just shown
        if config.developer:
            for i in range(len(args)):
                if i > 0 and not args[i].startswith('with'):
                    renpy.exports.show(args[i], at_list=[Transform(blur=8.0)])
    
    # Replace the scene function
    renpy.exports.scene = _dev_scene

init python:

    import random

    # Global registry of all NPCs
    all_npcs = []

    class NPC:
        
        def __init__(self, character, species, cock_size, dominance, confidence, attraction, satisfaction, image_base=None, first_class=False):
            # Core attributes that define this sexual creature
            self.character = character
            self.species = species
            self.cock_size = cock_size
            self.dominance = dominance
            self.confidence = confidence
            self.attraction = attraction
            self.satisfaction = satisfaction
            

            # Image handling - store the base name for images (clothed, nude, aroused states)
            self.image_base = image_base or character.name.lower().replace(" ", "_")

            self.first_class = first_class
            self.romanceable = False
            self.hearts = 0
            self.romance = 0
            self.scenes_completed = []
            self.exclude_placeholder = False  # Instance variable to track placeholder exclusion


            
            # Locations where you can find this npc for an encounter
            self.minigame_type = None
            self.bar_scene = None
            self.shower_scene = None
            self.restroom_scene = None
            self.regional_scene = None
            self.singleaisle_scene = None
            
            self.temp1 = None
            self.temp2 = None
            self.temp3 = None
            self.temp4 = None
            self.temp5 = None

            self.enCounter = 0  # How many times you've fucked this NPC
            
            # Dictionary for cruising_altitude minigame values
            self.cruising_altitude = {}
            
            # Dictionary for charisma minigame data
            self.charisma_minigame = {
                "intro_text": "",                # Introduction text
                "species_traits": [],            # Character traits based on species
                "personality_type": "",          # Business, Leisure, Nervous, Flirtatious, VIP
                "interests": [],                 # List of topics they respond well to
                "interactions": [],              # List of interaction objects for the minigame
                "decline_label": "",             # Label to jump to for decline ending
                "oral_label": "",                # Label to jump to for oral ending
                "anal_label": ""                 # Label to jump to for anal/special ending
            }
            
            # Add self to global registry
            all_npcs.append(self)

        # Enhanced image methods
        def show(self, state=None, at_list=None, with_transition=None, layer="master", zorder=None, tag=None, behind=None, **kwargs):
            """
            Display this sexual partner with optional state (nude, erect, etc.)
            
            Parameters:
            - state: Optional state suffix (e.g., "nude", "erect", "cumming")
            - at_list: List of transforms to apply
            - with_transition: Transition to use (e.g., dissolve, fade)
            - layer: Layer to show on (default: "master")
            - zorder: Z-order for layering
            - tag: Tag to use (defaults to image_base)
            - behind: List of tags this image should appear behind
            - **kwargs: Additional keyword arguments for renpy.show()
            """
            if state:
                image_name = f"{self.image_base}_{state}"
            else:
                image_name = self.image_base
                
            # Use the character's name as the tag if not specified
            if tag is None:
                tag = self.image_base
            
            # IMPORTANT: Initialize behind as an empty list if it's None
            if behind is None:
                behind = []
            # Ensure behind is always a list, never a string
            elif not isinstance(behind, list):
                behind = [behind]
            
            renpy.show(image_name, at_list=at_list, layer=layer, zorder=zorder, tag=tag, behind=behind, **kwargs)
            
            # Only show placeholder overlay if this NPC is not excluded
            if not self.exclude_placeholder:
                # Show placeholder overlay with higher zorder, fixed 80% scale and 20% lower
                overlay_zorder = 999 if zorder is None else zorder + 10
                
                # Create fixed placeholder transform with 80% scale
                # Extract only position information from the original transforms if available
                # but use our fixed scale
                overlay_transform = Transform(
                    zoom=0.8,  # Fixed 80% scale regardless of character image scale
                    ypos=0.35,  # Fixed position at 35% down from top of screen
                    yanchor=0.5,  # Center anchor point vertically
                )
                
                # If original transforms exist, try to copy only horizontal position attributes
                if at_list:
                    for transform in at_list:
                        if isinstance(transform, Transform):
                            # Extract ONLY horizontal position attributes
                            if hasattr(transform, 'xpos') and transform.xpos is not None:
                                overlay_transform.xpos = transform.xpos
                            if hasattr(transform, 'xanchor') and transform.xanchor is not None:
                                overlay_transform.xanchor = transform.xanchor
                            # Intentionally NOT copying ypos or yanchor
                
                # Show with the fixed transform
                renpy.show("placeholder_overlay", at_list=[overlay_transform], layer=layer, zorder=overlay_zorder, tag=f"{tag}_overlay")
            
            if with_transition:
                renpy.with_statement(with_transition)
            
        def hide(self, with_transition=None, layer="master"):
            """
            Hide this NPC
            
            Parameters:
            - with_transition: Transition to use (e.g., dissolve, fade)
            - layer: Layer to hide from (default: "master")
            """
            renpy.hide(self.image_base, layer=layer)
            # Also hide the overlay
            renpy.hide(f"{self.image_base}_overlay", layer=layer)
            
            if with_transition:
                renpy.with_statement(with_transition)
            
        def move(self, new_position, duration=1.0, with_transition=None, **kwargs):
            """
            Move this NPC to a new position using a transform
            
            Parameters:
            - new_position: The new position (e.g., left, right, center or a Transform)
            - duration: Duration of the movement in seconds
            - with_transition: Transition to use after the movement
            - **kwargs: Additional keyword arguments for the transform
            """
            # Create a transform that moves from current position to new position
            move_transform = Transform(function=lambda old_widget, new_widget: new_widget)
            
            if isinstance(new_position, Transform):
                for attr, value in vars(new_position).items():
                    if attr != 'function' and not attr.startswith('_'):
                        setattr(move_transform, attr, value)
            else:
                # Assume it's a predefined transform like 'left', 'right', etc.
                move_transform = new_position
                
            # Apply duration if specified
            if duration != 1.0:
                move_transform = Transform(move_transform, time=duration)
                
            # Show with the new transform
            self.show(at_list=[move_transform], **kwargs)
            
            if with_transition:
                renpy.with_statement(with_transition)

        # Fixed stat modification methods to use getattr/setattr
        def stat_increase(self, stat_name, amount):
            # Increase a sexual attribute (bigger cock, more dominant, etc.)
            if hasattr(self, stat_name):
                current_value = getattr(self, stat_name)
                setattr(self, stat_name, current_value + amount)

        def stat_decrease(self, stat_name, amount):
            # Decrease a sexual attribute (smaller cock, less dominant, etc.)
            if hasattr(self, stat_name):
                current_value = getattr(self, stat_name)
                setattr(self, stat_name, current_value - amount)

        def encounter(self):
            # Track each time you fuck this character
            self.enCounter += 1
            
        @staticmethod
        def get_all_npcs():
            """Return the global list of all NPCs"""
            return all_npcs
            
        @staticmethod
        def get_random_npc(exclude_list=None):
            """Get a random NPC, prioritizing those not yet encountered"""
            if not all_npcs:
                return None
                
            available_npcs = list(all_npcs)
            if exclude_list:
                available_npcs = [npc for npc in available_npcs if npc not in exclude_list]
                
            if not available_npcs:
                return None
                
            # Prioritize NPCs that haven't been encountered yet
            unseen_npcs = [npc for npc in available_npcs if npc.enCounter == 0]
            if unseen_npcs:
                selected_npc = random.choice(unseen_npcs)
            else:
                selected_npc = random.choice(available_npcs)
                
            selected_npc.enCounter += 1
            return selected_npc
            

        # Charisma minigame methods
        def get_charisma_intro(self):
            """Get the introduction text for the charisma minigame"""
            return self.charisma_minigame.get("intro_text", "")
            
        def get_charisma_personality(self):
            """Get the personality type for the charisma minigame"""
            return self.charisma_minigame.get("personality_type", "")
            
        def get_charisma_interests(self):
            """Get the interests for the charisma minigame"""
            return self.charisma_minigame.get("interests", [])
            
        def get_charisma_interactions(self):
            """Get the interactions for the charisma minigame"""
            return self.charisma_minigame.get("interactions", [])
            
        def get_charisma_ending_label(self, outcome):
            """Get the label for the specified ending"""
            if outcome == "decline":
                return self.charisma_minigame.get("decline_label", "")
            elif outcome == "oral":
                return self.charisma_minigame.get("oral_label", "")
            else:  # anal/special ending
                return self.charisma_minigame.get("anal_label", "")
                
        def set_charisma_minigame_data(self, data):
            """Set the charisma minigame data"""
            self.charisma_minigame.update(data)
            
        @classmethod
        def exclude_from_placeholder(cls, npc_or_list):
            """
            Set NPC(s) to exclude from placeholder overlay.
            
            Parameters:
            - npc_or_list: Single NPC instance or list of NPC instances
            """
            if isinstance(npc_or_list, list):
                for npc in npc_or_list:
                    npc.exclude_placeholder = True
            else:
                npc_or_list.exclude_placeholder = True
                    
        @classmethod
        def include_placeholder(cls, npc_or_list):
            """
            Set NPC(s) to include placeholder overlay.
            
            Parameters:
            - npc_or_list: Single NPC instance or list of NPC instances
            """
            if isinstance(npc_or_list, list):
                for npc in npc_or_list:
                    npc.exclude_placeholder = False
            else:
                npc_or_list.exclude_placeholder = False
                    
        @classmethod
        def get_placeholder_excluded(cls):
            """Get the list of NPCs excluded from placeholder overlay"""
            return [npc for npc in all_npcs if npc.exclude_placeholder]
            
        @classmethod
        def get_npc_by_character_name(cls, character_name):
            """Get an NPC by their character's name"""
            for npc in all_npcs:
                if npc.character.name == character_name:
                    return npc
            return None

    class Player:
        def __init__(self, name, color, charisma=0, sexperience=0, endurance=0, agility=0, intellect=0):
            self.name = name
            self.color = color
            self.charisma = charisma  
            self.sexperience = sexperience  #sexual skill level
            self.endurance = endurance  
            self.agility = agility  
            self.intellect = intellect  
            self.miles = 0
            self.points = 5  # Skill points to allocate
            self.level = 1  # Player Level


            #Confidence/Submissiveness Axis
            self.confidence = 0
            self.submissiveness = 0
            self.assertiveness = 0
            
            #Flirty/Funny Axis
            self.humor = 0
            self.flirtiness = 0
            
            # Sexual skill attributes - base values without sexperience bonus
            self.base_oral_skill = 0  # Base skill at oral sex
            self.base_anal_skill = 0  # Base skill at anal sex
            self.base_usability = 0  # Skill at handling multiple partners
            self.base_kink_experience = 0  # Experience with non-standard activities

            self.aircraft_type = "Regional Jet"

            self.day = 0


        def new_day(self):
            self.day += 1

        # Fixed stat modification methods to use getattr/setattr
        def stat_increase(self, stat_name, amount):
            # Improve a sexual attribute
            if hasattr(self, stat_name):
                current_value = getattr(self, stat_name)
                setattr(self, stat_name, current_value + amount)

        def stat_decrease(self, stat_name, amount):
            # Decrease a sexual attribute
            if hasattr(self, stat_name):
                current_value = getattr(self, stat_name)
                setattr(self, stat_name, current_value - amount)

        def earnMiles(self, amount, skill_name=None):
            """
            Earn miles with optional skill multiplier, display the summary screen, and update miles total.
            
            Args:
                amount (int): Base miles earned
                skill_name (str, optional): Name of the skill to use for multiplier (e.g., "agility")
            
            Returns:
                int: Total miles earned including multiplier
            """
            # Store starting balance for the summary screen
            starting_balance = self.miles
            
            # Calculate miles with multiplier if skill provided
            if skill_name:
                skill_value = getattr(self, skill_name, 0)
                skill_multiplier = 1 + (skill_value / 10.0)
                miles_with_multiplier = int(amount * skill_multiplier)
            else:
                miles_with_multiplier = amount
            
            # Call the miles summary screen
            renpy.call_screen("miles_summary_screen", starting_balance, amount, skill_name)
            
            # Update miles total
            self.miles += miles_with_multiplier
            
            return miles_with_multiplier

        def level_up(self, stat_name=None):
            # First increase the level and record the initial points count
            self.level += 1
            
            # Apply automatic +1 to all base stats
            self.charisma += 1
            self.agility += 1
            self.intellect += 1
            
            # Increase the specific stat if provided
            if stat_name and hasattr(self, stat_name):
                current_value = getattr(self, stat_name)
                setattr(self, stat_name, current_value + 1)
            
            # Hide dialogue before calling screen and use _window=False to prevent it from showing
            renpy.hide_screen("say")
            _window_auto = renpy.store._window_auto
            renpy.store._window_auto = False
            
            # Call the level up screen to let player allocate 2 points
            temp_stats = renpy.call_screen("level_up_screen")
            
            # Restore window auto setting
            renpy.store._window_auto = _window_auto
            
            # Apply the allocated points from temp_stats
            self.agility += temp_stats["agility"]
            self.charisma += temp_stats["charisma"]
            self.intellect += temp_stats["intellect"]

        def add_points(self, amount):
            self.points += amount
            
        # Property methods to calculate total skills including sexperience bonus
        @property
        def oral_skill(self):
            """Total oral skill including sexperience bonus"""
            # Base skill plus half of sexperience (rounded down)
            return self.base_oral_skill + (self.sexperience // 2)
        
        @property
        def anal_skill(self):
            """Total anal skill including sexperience bonus"""
            # Base skill plus half of sexperience (rounded down)
            return self.base_anal_skill + (self.sexperience // 2)
        
        @property
        def usability(self):
            """Ability to handle multiple partners"""
            return self.base_usability + (self.sexperience // 3)
        
        @property
        def kink_experience(self):
            """Experience with non-standard activities"""
            return self.base_kink_experience + (self.sexperience // 3)
        
        # Enhanced sexual encounter tracking
        def process_encounter(self, oral=False, anal=False, num_partners=1, kinks=False, intensity=1):
            """
            Process a sexual encounter and update relevant stats
            
            Parameters:
            - oral: Whether oral sex was performed (True/False)
            - anal: Whether anal sex was performed (True/False)
            - num_partners: Number of partners involved (default: 1, max: 3)
            - kinks: Whether the encounter involved kinky activities (True/False)
            - intensity: How intense the encounter was (1-3 scale)
                1: Mild/Gentle - Basic encounter
                2: Moderate - Enthusiastic, passionate encounter
                3: Intense - Rough, overwhelming, or extraordinary encounter
                
            Returns a dict with the skills improved and by how much
            """
            # Validate intensity between 1-3
            if intensity < 1:
                intensity = 1
            elif intensity > 3:
                intensity = 3
            
            # Validate num_partners between 1-3
            if num_partners < 1:
                num_partners = 1
            elif num_partners > 3:
                num_partners = 3
            
            # Track what improved and by how much
            improvements = {}
            
            # Base skill gain value (can be adjusted in the future)
            base_gain = 1.0
            
            # Remove sexperience gain - sexperience is now only increased through leveling up
            # skill_multiplier now only uses the current sexperience without increasing it
            skill_multiplier = (intensity + num_partners) * (1 + self.sexperience/10)
            
            # Oral skill improvement
            if oral:
                oral_gain = base_gain * skill_multiplier
                self.base_oral_skill += oral_gain
                improvements["oral_skill"] = oral_gain
            
            # Anal skill improvement
            if anal:
                anal_gain = base_gain * skill_multiplier
                self.base_anal_skill += anal_gain
                improvements["anal_skill"] = anal_gain
            
            # Multiple partners increases usability - COMMENTED OUT FOR VERSION 1
            # if num_partners > 1:
            #     usability_gain = 0.5 * (num_partners - 1) * intensity
            #     self.base_usability += usability_gain
            #     improvements["usability"] = usability_gain
            #     
            #     # Multiple partners also increases endurance
            #     endurance_gain = 0.2 * (num_partners - 1)
            #     self.endurance += endurance_gain
            #     improvements["endurance"] = endurance_gain
            
            # Kinky activities increase kink experience - COMMENTED OUT FOR VERSION 1
            # if kinks:
            #    kink_gain = 0.7 * intensity
            #    self.base_kink_experience += kink_gain
            #    improvements["kink_experience"] = kink_gain
            
            # Return what improved
            return improvements
            
        # These methods still exist but are now wrappers around process_encounter
        def improve_oral(self, amount=1, num_partners=1):
            """Improve oral skill after an oral encounter (legacy method)"""
            return self.process_encounter(oral=True, intensity=amount, num_partners=num_partners)
        
        def improve_anal(self, amount=1, num_partners=1):
            """Improve anal skill after an anal encounter (legacy method)"""
            return self.process_encounter(anal=True, intensity=amount, num_partners=num_partners)
        
        # Add this new method to the Player class
        def get_rounded_skill(self, skill_name):
            """
            Returns a rounded integer value for the specified skill
            
            Parameters:
            - skill_name: Name of the skill ('oral_skill', 'anal_skill', etc.)
            
            Returns the skill value rounded to the nearest integer
            """
            if skill_name == "oral_skill":
                return int(round(self.oral_skill))
            elif skill_name == "anal_skill":
                return int(round(self.anal_skill))
            elif skill_name == "usability":
                return int(round(self.usability))
            elif skill_name == "kink_experience":
                return int(round(self.kink_experience))
            else:
                # For other stats that don't need property calculations
                if hasattr(self, skill_name):
                    value = getattr(self, skill_name)
                    return int(round(value))
                return 0

        # Refactor the description methods to use the new utility method
        def get_oral_description(self):
            """Get a description of oral skill level"""
            skill = self.get_rounded_skill("oral_skill")
            
            if skill <= 5:
                return "Inexperienced"
            elif skill <= 10:
                return "Novice"
            elif skill <= 20:
                return "Amateur"
            elif skill <= 40:
                return "Skilled"
            elif skill <= 70:
                return "Expert"
            else:  # >70
                return "Throat GOAT"
            
        def get_anal_description(self):
            """Get a description of anal skill level"""
            skill = self.get_rounded_skill("anal_skill")
            
            if skill <= 5:
                return "Inexperienced"
            elif skill <= 10:
                return "Novice"
            elif skill <= 20:
                return "Amateur"
            elif skill <= 40:
                return "Skilled"
            elif skill <= 70:
                return "Expert"
            else:  # >70
                return "Cock Destroyer"
        
        def get_usability_description(self):
            """Get a description of usability level"""
            skill = self.get_rounded_skill("usability")
            if skill == 0:
                return "One at a Time"
            elif skill <= 5:
                return "Double Trouble"
            elif skill <= 10:
                return "Group Enthusiast"
            elif skill <= 20:
                return "Orgy Expert"
            elif skill <= 35:
                return "Master of Many"
            else:
                return "Living Sex Party"
            
        def get_kink_description(self):
            """Get a description of kink experience level"""
            skill = self.get_rounded_skill("kink_experience")
            if skill == 0:
                return "Vanilla"
            elif skill <= 5:
                return "Experimenting"
            elif skill <= 10:
                return "Adventurous"
            elif skill <= 20:
                return "Kinky"
            elif skill <= 35:
                return "Deviant"
            else:
                return "Fetish Master"

        def get_personality_axis(self):
            """
            Returns information about both personality axes in a dictionary.
            
            Returns:
                dict: A dictionary containing both personality axis information:
                {
                    "confidence_axis": {
                        "dominant_trait": "confidence", "submissiveness", or "balanced",
                        "delta": numeric difference between the two stats
                    },
                    "flirt_axis": {
                        "dominant_trait": "flirtiness", "humor", or "balanced",
                        "delta": numeric difference between the two stats
                    }
                }
            """
            # Calculate confidence axis info
            confidence_delta = abs(self.confidence - self.submissiveness)
            if self.confidence > self.submissiveness:
                confidence_dominant = "confidence"
            elif self.submissiveness > self.confidence:
                confidence_dominant = "submissiveness"
            else:
                confidence_dominant = "balanced"
            
            # Calculate flirt axis info
            flirt_delta = abs(self.flirtiness - self.humor)
            if self.flirtiness > self.humor:
                flirt_dominant = "flirtiness"
            elif self.humor > self.flirtiness:
                flirt_dominant = "humor"
            else:
                flirt_dominant = "balanced"
            
            # Return both as a dictionary
            return {
                "confidence_axis": {
                    "dominant_trait": confidence_dominant,
                    "delta": confidence_delta
                },
                "flirt_axis": {
                    "dominant_trait": flirt_dominant,
                    "delta": flirt_delta
                }
            }


    class Location:
        # Track all locations
        all_locations = []
        
        def __init__(self, name, description, background, location_attribute=None):
            self.name = name
            self.description = description
            self.background = background
            self.location_attribute = location_attribute  # The attribute name to check on NPCs (e.g., "bar_scene")
            self.NPCs = []
            self.seen_NPCs = []
            self.unseen_NPCs = []
            
            # Add to global locations list
            Location.all_locations.append(self)

        def populate_from_attributes(self):
            """Populate this location with NPCs that have this location's attribute set"""
            if not self.location_attribute:
                return
                
            self.NPCs = []
            self.seen_NPCs = []
            self.unseen_NPCs = []
            
            for npc in NPC.get_all_npcs():
                if hasattr(npc, self.location_attribute) and getattr(npc, self.location_attribute) is not None:
                    self.NPCs.append(npc)
                    if npc.enCounter > 0:
                        self.seen_NPCs.append(npc)
                    else:
                        self.unseen_NPCs.append(npc)

        def organize_NPCs(self):
            for char in list(self.unseen_NPCs):  #Use list() to avoid modifying during iteration
                if char.enCounter > 0:
                    self.seen_NPCs.append(char)
                    self.unseen_NPCs.remove(char)

        def add_NPC(self, char):
            if char not in self.NPCs:
                self.NPCs.append(char)
                if char.enCounter == 0:
                    self.unseen_NPCs.append(char)
                else:
                    self.seen_NPCs.append(char)

        def remove_NPC(self, char):
            if char in self.NPCs:
                self.NPCs.remove(char)
                if char in self.seen_NPCs:
                    self.seen_NPCs.remove(char)
                if char in self.unseen_NPCs:
                    self.unseen_NPCs.remove(char)

        def get_NPCs(self):
            return self.NPCs

        def get_random_NPC(self):
            # Create a copy to avoid modifying the original list
            available_npcs = list(self.unseen_NPCs)
            if not available_npcs:  # If no unseen NPCs, use all NPCs
                available_npcs = list(self.NPCs)
            
            if available_npcs:
                random.shuffle(available_npcs)
                selected_npc = available_npcs[0]
                selected_npc.enCounter += 1
                # Move to seen if it was unseen
                if selected_npc in self.unseen_NPCs:
                    self.seen_NPCs.append(selected_npc)
                    self.unseen_NPCs.remove(selected_npc)
                return selected_npc
            return None  # Return None if no NPCs available
            
        @staticmethod
        def get_all_locations():
            """Return all locations"""
            return Location.all_locations
            
        @staticmethod
        def populate_all_locations():
            """Populate all locations with NPCs based on their attributes"""
            for location in Location.all_locations:
                location.populate_from_attributes()
                
        @staticmethod
        def get_location_by_name(name):
            """Find a location by name"""
            for location in Location.all_locations:
                if location.name == name:
                    return location
            return None

        def show_background(self):
            """Show this location's background"""
            if self.background:
                renpy.scene()
                renpy.show(self.background)


    stat_descriptions = {
        "charisma": "Affects character interactions and how much they enjoy your company",
        "sexperience": "Deprecated. Replaced by Anal Skill and Oral Skill",
        "endurance": "Deprecated. Will be removed in future updates",
        "agility": "Improves performance in dexterity based skills and tasks",
        "intellect": "Enhances memory and order processing capabilities"
    }
    
    def reset_stats(mc):
        mc.charisma = 0
        mc.sexperience = 0
        mc.endurance = 0
        mc.agility = 0
        mc.intellect = 0
        mc.points = 5
    
    # Function to check if a character name belongs to a romanceable NPC
    def is_romanceable_character(character_name):
        """Check if a character name belongs to a romanceable NPC"""
        if not character_name:
            return False
        npc = NPC.get_npc_by_character_name(character_name)
        return npc is not None and npc.romanceable

    def reset_game_state():
        """Reset runtime game state for a fresh new game."""
        # Recreate the player to clear any previous run mutations
        renpy.store.mc = Player("River", "#0f3164")

        # Ensure day/miles and core points are in their initial state
        renpy.store.mc.day = 0
        renpy.store.mc.miles = 0
        renpy.store.mc.points = 5
        renpy.store.mc.level = 1

        # Reset screen/session-level helper vars
        renpy.store.shuffle = False
        # These exist in screens and are safe to set/reset here
        renpy.store.first_day_started = False
        renpy.store.points_to_allocate = 2

        # Reset NPC runtime state so encounters and romance progress don't carry over
        for npc in NPC.get_all_npcs():
            npc.enCounter = 0
            npc.hearts = 0
            npc.romance = 0
            npc.scenes_completed = []
            npc.temp1 = None
            npc.temp2 = None
            npc.temp3 = None
            npc.temp4 = None
            npc.temp5 = None


#CHARACTER DEFINITIONS
define narrator = Character(None, color="#FFFFFF")

# Set "Narrator" as default speaker name when no character is specified
init python:
    # This configuration option is not supported in Ren'Py 8.3.7
    # config.narrator_name = "Narrator"
    pass


define driver = Character("Driver", color="#000000")
define human_airline_employee = Character("Airline Employee", color="#00367d")
define barista = Character("Barista", color="#2a2a2aff")
define gate_agent = Character("Gate Agent", color="#a53a01")
define flight_attendant = Character("Flight Attendant", color="#bd9b00")


define boris_char = Character("? Bear-like Man ?", color="#8B4513")  # Brown for bear
define panther_security_char = Character("Panther Security Agent", color="#1A1A1A")  # Near black for panther
define boar_security_char = Character("Boar Security Agent", color="#713737ff")  # brown for boar
define secretary_char = Character("Secretary", color="#FF7F50")  # Coral for fox
define ceo_char = Character("Darius Pridemore, CEO", color="#C19A6B")  # Lion's mane gold
define warren_char = Character("Mr. Warren", color="#474e5c")  # dark blue-grey for rabbit
define mangy_coyote_char = Character("Mangy Coyote", color="#D2B48C")  # Tan/sandy for coyote
define clutch_char = Character("Clutch", color="#636363")  # Gray for raccoon
define grizz_char = Character("Grizz", color="#704214")  # Dark brown for bear
define fang_char = Character("Fang", color="#4F4F4F")  # Dark gray for wolf
define brutus_char = Character("Brutus", color="#8C8C8C")  # Gray for rhino
define wallow_char = Character("Wallow", color="#4a5253")  # Cadet blue for hippo
define dash_char = Character("Dash", color="#F0C05A")  # Golden yellow for cheetah
define prof_ivory_char = Character("Professor Ivory", color="#E8E4C9")  # Ivory color for elephant
define garrick_char = Character("Garrick", color="#B87333")  # Copper brown for warthog
define chuckles_char = Character("Chuckles", color="#62dddf")  # mowhak color for hyena
define quincy_char = Character("Quincy", color="#C0C0C0")  # Silver gray for mouse/rat
define douglas_char = Character("Douglas", color="#8B7355")  # Wood brown for moose
define balthazar_char = Character("Balthazar", color="#0A0A0A")  # Deep black for black bull
define chop_char = Character("Chop", color="#FFB6C1")  # Light pink for pig
define zephyr_char = Character("Zephyr", color="#c64f5d")  # Pink for warthog
define finn_char = Character("Finn", color="#D2B48C")  # Tan for meerkat
define kogo_char = Character("Kogo", color="#4C4C4C")  # Dark gray for gorilla
define brodie_char = Character("Brodie", color="#D4AF37")  # Gold for stallion/horse
define black_rhino_char = Character("Black Rhino", color="#464646")  # Dark gray for black rhino
define wesley_char = Character("Wesley", color="#8B4513")  # Brown color for minotaur
define captain_sterling_char = Character("Captain Sterling", color="#808080")  # Gray for the older wolf
define trent_char = Character("Trent", color="#FFD700")  # Gold for the younger wolf's golden eyes
define jin_char = Character("Jin", color="#F4A460")  # Sandy brown for tiger
define thick_warthog_char = Character("Thick Warthog", color="#B22222")  # Dark red for warthog
define passive_rabbit_char = Character("Passive Rabbit", color="#E6E6FA")  # Lavender for rabbit
define finley_char = Character("Finley", color="#8B5A2B")  # Brown for deer
define penwick_char = Character("Penwick", color="#2E2E2E")  # Dark gray for panda
define marcus_char = Character("Marcus", color="#7C7C7C")  # Silver-gray for wolf
define drunk_bear_char = Character("Bradley", color="#1f2750")  # Blue-gray for bear
define drunk_horse_char = Character("Nate", color="#d96e21")  # Orange for horse

#NPC/PC DEFINITIONS
init 1 python:
    
    # PLAYER DEFINITION
    mc = Player("River", "#0f3164")
    
    # NPC DEFINITIONS - using image_base parameter to specify the base image name
    boris = NPC(boris_char, "Bear", 10, 10, 10, 10, 10, image_base="boris")
    panther_security = NPC(panther_security_char, "Panther", 8, 8, 8, 9, 10, image_base="panther_security")
    boar_security = NPC(boar_security_char, "Boar", 8, 8, 8, 9, 10, image_base="boar_security")
    secretary = NPC(secretary_char, "Fox", 7, 7, 10, 7, 7, image_base="secretary")

    
    ceo = NPC(ceo_char, "Lion", 9, 10, 10, 1, 1, image_base="ceo")
    warren = NPC(warren_char, "Rabbit", 6, 5, 5, 9, 9, image_base="warren")
    mangy_coyote = NPC(mangy_coyote_char, "Coyote", 7.5, 7, 10, 7, 5, image_base="mangy_coyote")
    mangy_coyote.minigame_type = "🍸"
    # Maintenance Raccoon
    clutch = NPC(clutch_char, "Raccoon", 7, 6, 8, 7, 8, image_base="clutch")
    clutch.romanceable = True
    
    # NPCs with location assignments
    grizz = NPC(grizz_char, "Bear", 9.5, 10, 10, 10, 10, image_base="lounge_grizz")
    grizz.bar_scene = "grizz_introduction"
    grizz.romanceable = True
    
    fang = NPC(fang_char, "wolf", 8, 8, 10, 8, 10)
    fang.bar_scene = "fang_businessman_direwolf_1"
    
    brutus = NPC(brutus_char, "Rhino", 9, 10, 10, 10, 10, image_base="lounge_brutus")
    brutus.bar_scene = "brutus_retiree_rhino_1"
    
    wallow = NPC(wallow_char, "Hippo", 9, 10, 10, 10, 10, image_base="lounge_wallow")
    wallow.bar_scene = "wallow_businessman_hippo_1"

    dash = NPC(dash_char, "Cheetah", 9, 10, 10, 10, 10, image_base="lounge_dash")
    dash.bar_scene = "dash_athlete_cheetah_1"

    prof_ivory = NPC(prof_ivory_char, "Elephant", 9, 10, 10, 10, 10, image_base="lounge_profivory")
    prof_ivory.bar_scene = "prof_ivory_bartender_elephant_1"

    garrick = NPC(garrick_char, "Warthog", 9, 10, 10, 10, 10)
    garrick.bar_scene = "garrick_businessman_warthog_1"

    chuckles = NPC(chuckles_char, "Hyena", 9, 10, 10, 10, 10, image_base="lounge_chuckles")
    chuckles.bar_scene = "chuckles_comedian_hyena_1"

    quincy = NPC(quincy_char, "Mouse", 9, 10, 10, 10, 10, image_base="lounge_quincy")
    quincy.bar_scene = "quincy_artist_rat_1"

    douglas = NPC(douglas_char, "Moose", 9, 10, 10, 10, 10)
    douglas.bar_scene = "douglas_businessman_moose_1"

    balthazar = NPC(balthazar_char, "Bull", 12, 10, 10, 10, 10)
    balthazar.shower_scene = "balthazar_consultant_black_bull_1"

    chop = NPC(chop_char, "Pig", 9, 10, 10, 10, 10)
    chop.regional_scene = "chop_regional_1_v2"
    chop.minigame_type = "💬"
    zephyr = NPC(zephyr_char, "Warthog", 11, 9, 10, 8, 10, image_base="zephyr")
    #zephyr.shower_scene = "zephyr_finn_shower_scene"

    finn = NPC(finn_char, "Meerkat", 8, 7, 10, 9, 10, image_base="finn")
    finn.shower_scene = "zephyr_finn_shower_scene"

    # Locker room gorilla NPC
    kogo = NPC(kogo_char, "Gorilla", 9, 10, 10, 8, 10, image_base="kogo")
    #kogo.shower_scene = "kogo_shower_scene" 

    # Stallion NPC
    brodie = NPC(brodie_char, "Stallion", 12, 8, 9, 10, 10, image_base="brodie")
    brodie.shower_scene = "brodie_shower_scene"  

    # New NPC definition
    black_rhino = NPC(black_rhino_char, "Black Rhino", 11, 10, 10, 8, 10, image_base="black_rhino")
    black_rhino.regional_scene = "black_rhino_regional_scene"
    black_rhino.minigame_type = "🛎️"
    # Add to NPC/PC DEFINITIONS section in init 1 python block
    wesley = NPC(wesley_char, "Bison", 10, 9, 7, 9, 10, image_base="wesley")
    wesley.regional_scene = "wesley_regional_1"
    wesley.minigame_type = "🛎️"
    # Add to NPC/PC DEFINITIONS section in init 1 python block
    captain_sterling = NPC(captain_sterling_char, "Wolf", 9, 8, 9, 7, 9, image_base="captain_sterling")
    #captain_sterling.regional_scene = "wolf_pilots_regional_scene"
    captain_sterling.minigame_type = "💬"
    # Add to NPC/PC DEFINITIONS section in init 1 python block
    trent = NPC(trent_char, "Wolf", 10, 9, 10, 10, 10, image_base="trent")
    #Hiding this scene for now
    #trent.regional_scene = "wolf_pilots_regional_scene"

    # Add to NPC/PC DEFINITIONS section in init 1 python block
    jin = NPC(jin_char, "Tiger", 9, 10, 10, 9, 10, image_base="tiger")
    jin.regional_scene = "jin_lavatory_scene"
    jin.minigame_type = "💬"

    thick_warthog = NPC(thick_warthog_char, "Warthog", 9, 9, 9, 8, 10, image_base="thick_warthog")

    
    passive_rabbit = NPC(passive_rabbit_char, "Rabbit", 7, 5, 7, 10, 10, image_base="passive_rabbit")

    
    finley = NPC(finley_char, "Deer", 7, 6, 5, 8, 7, image_base="finley")
    finley.regional_scene = "finley_student_deer_v2"
    finley.minigame_type = "💬"
    # Intellectual panda passenger
    penwick = NPC(penwick_char, "Panda", 7, 6, 8, 7, 9, image_base="penwick")
    penwick.regional_scene = "penwick_regional_1"
    penwick.minigame_type = "🛎️"

    marcus = NPC(marcus_char, "Wolf", 9, 8, 10, 9, 10, image_base="marcus", first_class=True)
    marcus.regional_scene = "marcus_wolf_regional"
    marcus.minigame_type = "🍸"

    # College graduates from large_tip scene
    bradley = NPC(drunk_bear_char, "Bear", 9, 9, 9, 9, 10, image_base="bradley")
    bradley.regional_scene = "large_tip"
    bradley.minigame_type = "🍸"
    
    nate = NPC(drunk_horse_char, "Horse", 10, 8, 9, 10, 10, image_base="nate")
    nate.regional_scene = "large_tip"
    nate.minigame_type = "🍸"
    
    # PLACEHOLDER EXCLUSIONS
    # Add NPCs here as I receive their official artwork
    
    # Current exclusions:
    NPC.exclude_from_placeholder([ceo, secretary, grizz, chop, mangy_coyote, wesley, boris, finley])

# Define all locations and populate them
init 2 python:
    # LOCATION DEFINITIONS
    lounge_bar = Location("Lounge Bar", "The dim lighting casts a warm, inviting glow across the room.", "bg mile_high_mixer.jpg", "bar_scene")
    shower_room = Location("Shower Room", "Steam fills the air in this communal shower area.", "bg shower_room.jpg", "shower_scene")
    restroom = Location("Restroom", "A clean, private space for personal needs.", "bg restroom.jpg", "restroom_scene")
    regional_cabin = Location("Regional Cabin", "A smaller, more intimate cabin space.", "bg regional_cabin.jpg", "regional_scene")
    single_aisle = Location("Single Aisle", "The narrow corridor of the aircraft.", "bg single_aisle.jpg", "singleaisle_scene")
    
    # Populate all locations with NPCs based on their attributes
    Location.populate_all_locations()

# Make these variables default (persistent) NPCs
default mc = mc
default boris = boris
default panther_security = panther_security
default boar_security = boar_security
default secretary = secretary
default ceo = ceo
default warren = warren
default mangy_coyote = mangy_coyote
default clutch = clutch
default grizz = grizz
default fang = fang
default brutus = brutus
default wallow = wallow
default dash = dash
default prof_ivory = prof_ivory
default garrick = garrick
default chuckles = chuckles
default quincy = quincy
default douglas = douglas
default balthazar = balthazar
default chop = chop
default zephyr = zephyr
default finn = finn
default kogo = kogo
default brodie = brodie
default black_rhino = black_rhino
default wesley = wesley
default captain_sterling = captain_sterling
default trent = trent
default jin = jin
default thick_warthog = thick_warthog
default passive_rabbit = passive_rabbit
default finley = finley
default penwick = penwick
default marcus = marcus
default bradley = bradley
default nate = nate


#Persistent locations
default lounge_bar = lounge_bar
default shower_room = shower_room
default restroom = restroom
default regional_cabin = regional_cabin
default single_aisle = single_aisle

# Menu shuffling control variable
default shuffle = False

# Override the menu function to support conditional shuffling
init python:
    # Save the original menu function
    renpy_menu = menu
    
    def menu(items):
        """
        Custom menu function that shuffles items if shuffle variable is True.
        Properly handles conditional menu items by only shuffling visible ones.
        """
        if not shuffle:
            # If shuffle is False, use the normal menu function
            return renpy_menu(items)
        else:
            # Create a copy of items to avoid modifying the original
            items_copy = list(items)
            
            # Shuffle the copy
            import random
            random.shuffle(items_copy)
            
            # Call the original menu function with shuffled items
            # The original menu function will handle condition evaluation
            return renpy_menu(items_copy)




# The game starts here.
define dissolve_1 = Dissolve(1)
image splash = "overwood_logo_wide_4k.png"

# Define main menu music
define audio.main_menu_music = "sounds/main_menu_ambiance_rev2.ogg"

label splashscreen:
    scene black
    with Pause(1)

    #play sound "ping.ogg"

    show splash with dissolve_1:
        zoom 0.5
    with Pause(2)

    scene black with dissolve_1
    with Pause(1)

    # Call the disclaimer screen after logo
    call screen disclaimer_screen
    
    # Start main menu music with fade in
    play music main_menu_music fadein 2.0 loop

    return

label start:
    
    # Stop main menu music when starting the game
    stop music fadeout 2.0

    # Reset all runtime state to ensure a fresh playthrough
    $ reset_game_state()

    # Show a background. This uses a placeholder by default, but you can
    # add a file (named either "bg room.png" or "bg room.jpg") to the
    # images directory to show it.

    #scene bg room

    # This shows a character sprite. A placeholder is used, but you can
    # replace it by adding a file named "eileen happy.png" to the images
    # directory.

    #show eileen happy

    # These display lines of dialogue.

    #$ config.overlay_screens.append("persistent_stats_button")

    
    #Populate all locations with NPCs based on their attributes at RUNTIME
    $ Location.populate_all_locations()

    # Add debugging code to print all locations and NPCs
    python:
        print("=== DEBUG: All Locations ===")
        for loc in Location.get_all_locations():
            print(f"Location: {loc.name}, NPCs: {len(loc.NPCs)}")
            for npc in loc.NPCs:
                print(f"  - {npc.character.name} ({npc.species})")
        
        print("\n=== DEBUG: All NPCs ===")
        for npc in NPC.get_all_npcs():
            print(f"NPC: {npc.character.name}, Species: {npc.species}, Location attributes:")
            if npc.bar_scene: print(f"  - Bar scene: {npc.bar_scene}")
            if npc.shower_scene: print(f"  - Shower scene: {npc.shower_scene}")
            if npc.restroom_scene: print(f"  - Restroom scene: {npc.restroom_scene}")
            if npc.regional_scene: print(f"  - Regional scene: {npc.regional_scene}")
            if npc.singleaisle_scene: print(f"  - Single aisle scene: {npc.singleaisle_scene}")
    


    
    call prologue_v2 from _call_prologue_v2
    call new_life_v2 from _call_new_life_v2
    call first_day from _call_first_day
    
    
    while mc.day + 1 <=4:
        call gameplay_loop from _call_gameplay_loop
    scene black with fade

    #call end_of_demo
    $ mc.day += 1
    
    if mc.miles >= 2500:
        call end_of_demo from _call_end_of_demo
    
    
    "We are at the end of the demo! Thanks for playing!"
    "Your final miles for this playthrough are [mc.miles]!"
    "Our {a=https://www.kickstarter.com/projects/overwoodstudios/mile-high-maneuvers-by-overwood-studios?ref=8qjthf}Kickstarter{/a} is LIVE! Come help us make Mile High Maneuvers a reality!"
    

    # This ends the game.

    return