

# AM introduction scene - NOT part of the romance system
# This is a standalone scene that can be called separately
label clutch_introduction_am:
    $ shuffle = True
    scene bg airport_lobby_furry

    "You wander through the bustling airport corridors, trying your best to familiarize yourself with the layout as quickly as possible."
    
    "The signs pointing to various terminals and facilities blend together as you turn down yet another identical hallway."

    "Following what you thought was a shortcut to the crew lounge, you push through a set of heavy double doors and immediately realize your mistake."
    
    "Instead of the lounge, you've stumbled into what appears to be a restricted area."

    scene bg hangar

    "Before you can retreat, the expansive maintenance hangar opens up before you, and curiosity gets the better of you."
    
    "You decide to explore a bit further, figuring this is as good a time as any to learn about the operations side of the airline."

    "The maintenance hangar is brightly lit, the morning sun streaming through large windows. Tools are meticulously organized on wall panels."
    
    "Several mechanics of various species are working on different parts of an aircraft, but your eyes are drawn to a sectioned-off area in the corner where a \"DO NOT CROSS\" sign is prominently displayed."

    "Behind the makeshift barrier, you notice a raccoon slumped over in a chair, his jumpsuit stained with grease and his fur disheveled. A half-empty cup of coffee sits precariously balanced on a toolbox nearby."
    
    "His eyes are half-closed, and he seems to be struggling to stay awake."

    "Mechanic Hippo" "Hey, new human! Don't bother with Clutch right now. He's practically useless before sunset. Night shift guy."

    "As you approach the barrier, the raccoon's ears twitch slightly, and he glances up with a suspicious look. His amber eyes narrow as he notices you. Clearly a species he's never encountered before."

    $ clutch.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)

    clutch.character "What? You lost or something? Passengers aren't allowed in maintenance areas."
    
    "He reaches protectively for a wrench, keeping it close as if you might try to take it."

    menu:
        "He reaches protectively for a wrench, keeping it close as if you might try to take it."
        "Step forward with a confident smile and extend your hand":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            "You step forward with a confident smile, extending your hand in greeting."
            mc.name "I'm the new flight attendant! Just getting to know everyone around here. Nice to meet you!"
        
        "\"S-sorry to intrude... I'm the new flight attendant. I was just trying to find my way around...\"":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            mc.name "S-sorry to intrude... I'm the new flight attendant. I was just trying to find my way around..."
        
        "\"Wow, is that how you greet all your visitors? I'm the new flight attendant, not an industrial spy.\"":
            $ mc.humor += 1
            $ trait_used = "humor"
            mc.name "Wow, is that how you greet all your visitors? I'm the new flight attendant, not an industrial spy."
        
        "Give him a slow once-over before speaking":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            "You give him a slow, appreciative once-over before speaking."
            mc.name "I'm the new flight attendant, handsome. Thought I'd check out all the... equipment the airline has to offer."
    
    # Add romance points based on trait used
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    clutch.character "New flight attendant, huh? Great. Another person who's gonna come crying when the coffee machine breaks mid-flight."
    
    "He stands reluctantly, movements sluggish and uncoordinated compared to the careful precision you'd expect from a mechanic."

    "He steps forward but stops at his invisible boundary, unwilling to leave his workspace."

    clutch.character "Look, I'm Clutch. I fix things. I'm heading to sleep soon, so whatever you need fixed, tell someone else or come back tonight. Everything in this section is off-limits to non-maintenance personnel."
    
    "He gestures vaguely at his tools, all organized in a system only he seems to understand."

    "His gaze drifts to the coffee cup, then back to you with slightly more interest."

    clutch.character "Unless... you know how to make actual good coffee? Not that watered-down stuff they serve passengers?"

    "Even in his groggy state, you notice how his hands move constantly, fidgeting with small parts, his tactile nature evident despite his obvious fatigue."

    clutch.character "Can't believe they hired a human... what even are you? Some kind of hairless primate? Whatever..."
    
    "He turns back to his workbench, obviously dismissing you as he meticulously reorganizes a set of precision tools that already appeared perfectly arranged."

    $ clutch.hide(with_transition=dissolve)

    "You decide to leave him to his work, or sleep, or whatever he was about to do. Maybe he'll be more talkative later."

    show bg lounge_shower
    
    "Back in the lounge you quickly take a shower in the communal showers. Luckily, or unluckily, it is empty this time."

    "You quickly towel off and grab your uniform from your locker."

    # Mark scene as completed - AM scene is not part of romance system
    $ mark_scene_completed(clutch, "clutch_introduction_am")
    $ met_clutch = True  # Set flag that player has met Clutch
    #$ show_romance_notification(clutch, "You've met Clutch!")
    
    $ shuffle = False
    return


# Main introduction scene for Clutch (used by romance system)
label clutch_introduction:
    $ shuffle = True
    scene bg airport_lobby_furry
    
    "After your evening shift ends, you decide to take some time exploring parts of the airport you haven't seen yet. The passenger terminals have quieted down considerably compared to the daytime bustle."

    "You take a wrong turn somewhere past the international gates, and find yourself facing an unmarked door."
    
    "Thinking it might lead back to the crew area, you push it open and immediately realize you've wandered somewhere you probably shouldn't be."

    scene bg hangar_night

    "The distinctive smells of grease, fuel, and metal tell you exactly where you are before your eyes adjust to the dimmer lighting."

    if met_clutch:
        "You've accidentally found your way into the maintenance hangar again, though this time, the atmosphere is completely different from the morning."
    else:
        "You've accidentally found your way into the maintenance hangar. It seems pretty dead except for some movement over in the corner."
    
    "The maintenance hangar is dimly lit, with focused work lights creating pools of illumination in the otherwise shadowy space."
    
    "Most of the day shift has left, but activity continues in one corner where a raccoon moves with surprising grace between parts of a disassembled engine."

    if met_clutch:
        "Tools and parts that were neatly organized this morning are now spread out in what appears to be organized chaos. The 'DO NOT CROSS' barrier is still in place, but now seems to encompass a larger area."
    else:
        "Tools and parts are spread out in what appears to be organized chaos. A 'DO NOT CROSS' barrier is in place, closing off a large area."
    
    "The raccoon doesn't immediately notice you, completely absorbed in his work."
    
    if met_clutch:
        "His hands move with incredible precision, testing connections and making minute adjustments. Unlike this morning, his movements are fluid and confident."
    else:
        "His hands move with incredible precision, testing connections and making minute adjustments. His movements are fluid and confident."
    
    $ clutch.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "Suddenly he freezes, nose twitching as he catches your scent."

    if met_clutch:
    
        "He spins around, eyes reflecting the work lights, giving him an almost supernatural appearance in the dim hangar. When he spots you, his expression shifts from alertness to recognition."
        
        clutch.character "Well, look who's back! The human flight attendant, now during my hours. Much better timing."
        
        "His voice is animated and energetic, entirely different from the morning's grumpy mumbling."
        
        clutch.character "Clutch, fully awake this time. Night shift is when the real work happens."
        
        "He gestures to the exposed engine components with obvious pride."
        
        menu:
            "He seems much more animated than when you met him this morning."
            "\"I was exploring and ended up here again. You seem much more energetic than this morning! Nice to see you properly awake.\"":
                $ mc.assertiveness += 1
                $ trait_used = "assertiveness"
                mc.name "I was exploring and ended up here again. You seem much more energetic than this morning! Nice to see you properly awake."
                clutch.character "Ha! That wasn't me you met. That was a meat puppet running on autopilot."
            
            "Shuffle your feet and glance around nervously":
                $ mc.submissiveness += 1
                $ trait_used = "submissiveness"
                "You shuffle your feet nervously, glancing around the hangar."
                mc.name "I hope I'm not bothering you... I got lost again. You seem really different compared to this morning..."
                clutch.character "Different? Try actually conscious. Morning me is basically a zombie."
            
            "Give an exaggerated look of shock":
                $ mc.humor += 1
                $ trait_used = "humor"
                "You give an exaggerated look of shock, placing a hand over your heart dramatically."
                mc.name "Well well, someone had their coffee! And here I thought you were just naturally grumpy. What a transformation!"
                clutch.character "Coffee helps, but it's more about the sun being down. Nocturnal, remember?"
            
            "\"I might have gotten lost on purpose this time. You're much more... animated at night. I like this version of you better.\"":
                $ mc.flirtiness += 1
                $ trait_used = "flirtiness"
                mc.name "I might have gotten lost on purpose this time. You're much more... animated at night. I like this version of you better."
                clutch.character "Most people prefer the grumpy version. Less talking."
                "But there's a hint of a smile when he says it."

    else:

        "He spins around, eyes reflecting the work lights, giving him an almost supernatural appearance in the dim hangar. When he spots you, his expression shifts from suspicion to surprise."
        
        clutch.character "What? You lost or something? Passengers aren't allowed in maintenance areas."
        
        "He reaches protectively for a wrench, keeping it close as if you might try to take it."

        menu:
            "He eyes you suspiciously, wrench at the ready."
            "Step forward with a confident smile and extend your hand":
                $ mc.assertiveness += 1
                $ trait_used = "assertiveness"
                "You step forward with a confident smile, extending your hand in greeting."
                mc.name "I'm the new flight attendant! Just getting to know everyone around here. Nice to meet you!"
            
            "\"S-sorry to intrude... I'm the new flight attendant. I was just trying to find my way around...\"":
                $ mc.submissiveness += 1
                $ trait_used = "submissiveness"
                mc.name "S-sorry to intrude... I'm the new flight attendant. I was just trying to find my way around..."
            
            "\"Wow, is that how you greet all your visitors? I'm the new flight attendant, not an industrial spy.\"":
                $ mc.humor += 1
                $ trait_used = "humor"
                mc.name "Wow, is that how you greet all your visitors? I'm the new flight attendant, not an industrial spy."
            
            "Give him a slow once-over before speaking":
                $ mc.flirtiness += 1
                $ trait_used = "flirtiness"
                "You give him a slow, appreciative once-over before speaking."
                mc.name "I'm the new flight attendant, handsome. Thought I'd check out all the... equipment the airline has to offer."

        clutch.character "New flight attendant, huh? Great. Another person who's gonna come crying when the coffee machine breaks mid-flight."
        
        "He slowly relaxes, his posture loosening as he realizes you're not a threat."

        "He steps forward but stops at his invisible boundary, unwilling to leave his workspace."

        clutch.character "Sorry, just not used to other people in here at night. I'm Clutch. I fix things."
        
        "He gestures to the exposed engine components with obvious pride."
        
        clutch.character "Night shift is when the real work happens. Day crew just does basic maintenance. I handle the complex stuff."
    
    # Add romance points based on trait used
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    # Now continue with the conversation that works for both paths
    "He picks up a complex tool and begins fidgeting with it, constantly touching and adjusting things as he speaks."
    
    
    
    
    if met_clutch:
        clutch.character "Well, you came back after meeting morning me, so you're either brave or stupid. Most people run away after that encounter."
    else:
        clutch.character "So, a human flight attendant. First one I've seen. What exactly are you, anyway? Some kind of hairless primate?"
        clutch.character "Never seen anything like you before. The airline's really branching out with their hiring, huh?"

    "He continues working as he talks, hands never still."
    
    clutch.character "Most flight attendants are too busy serving drinks to care about how the aircraft actually stays in the air. But you're here, though."

    menu:
        "His tone is challenging, but there's a hint of genuine curiosity behind it."
        "Lean forward with genuine interest":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            "You lean forward, eyes bright with genuine interest."
            mc.name "Actually, I'm really curious about how everything works. The mechanics of flight have always fascinated me."
        
        "\"I-I know I'm just a flight attendant, but I really do want to learn more about the technical side...\"":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            mc.name "I-I know I'm just a flight attendant, but I really do want to learn more about the technical side..."
        
        "\"Hey, there's more to me than just my drink-pouring skills. I can walk and chew gum at the same time too!\"":
            $ mc.humor += 1
            $ trait_used = "humor"
            mc.name "Hey, there's more to me than just my drink-pouring skills. I can walk and chew gum at the same time too!"
        
        "Move closer to the barrier with a sultry look":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            "You move closer to the barrier, giving him a sultry look."
            mc.name "I'm interested in all kinds of... technical knowledge. Especially when it's explained by someone who knows what they're doing."
    
    # Add more romance points based on trait used
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    "A commotion from the other side of the hangar draws his attention momentarily. When he turns back to you, his expression has softened slightly."
    
    clutch.character "Listen, I'm in the middle of a time-sensitive repair, but..."
    
    "He seems to debate with himself before continuing."
    
    if met_clutch:
        clutch.character "You came back, which means you're either really lost or actually interested. If you're serious about learning how these birds work, I could show you some things."
        
        "He glances at his workspace, then back to you."
        
        clutch.character "Not now, obviously. But next time you're on night shift and I'm not buried in emergency repairs."
    else:
        clutch.character "If you're actually interested in how these birds stay in the air, I could show you a thing or two. Not now, but... maybe next time you're on night shift."
    
    "He gestures to a coffee maker in the corner, outside his territory."
    
    if met_clutch:
        clutch.character "Coffee's fresh. My special nighttime blend, not that morning swill. Help yourself if you want."
        
        "His expression turns more serious."
        
        clutch.character "And this time I mean it, don't move anything on my side of the line. Awake me is more charming, but also more particular about my tools."
    else:
        clutch.character "Coffee's fresh. Made it myself, special blend. Help yourself if you want. Just don't move anything on my side of the line."
        
        "He fixes you with a serious look."
        
        clutch.character "That's not a suggestion. These tools are precisely arranged. Touch them and we'll have problems."
    
    "He turns back to his work, but you notice him glancing over his shoulder, keeping track of your movements."
    
    "After a moment of work, he adds:"
    
    if met_clutch:
        clutch.character "Oh, and thanks for not holding this morning against me. Most people write me off after meeting zombie Clutch."
        
        "He pauses, then continues more seriously:"
        
        clutch.character "And same thing I said before. If you hear anything rattling in the cabin, tell me exactly what it sounds like. Details matter."
    else:
        clutch.character "Oh, and if you hear anything rattling in the cabin during flight, tell me exactly what it sounds like. Details matter. I don't accept 'it made a funny noise' as a maintenance report."
    
    "He grins, showing his sharp teeth, but this time it seems more friendly than threatening."
    
    $ clutch.hide(with_transition=dissolve)
    
    if met_clutch:
        "You decide to let him get back to his work. It's interesting seeing the difference between morning Clutch and night Clutch. Almost like two completely different people sharing the same body."
        
        "As you leave, you can't help but wonder which version is the 'real' Clutch, or if they both are in their own way."
    else:
        "You decide to let him get back to his work, though you might take him up on that coffee offer next time. He's definitely intense, but there's something intriguing about his dedication."
        
        "As you leave, you find yourself already planning when you might 'accidentally' wander back to the hangar."
    
    # Mark scene as completed - introduction automatically gives 1 heart
    $ mark_scene_completed(clutch, "clutch_introduction")
    $ show_romance_notification(clutch)
    $ clutch.hearts += 1
    $ renpy.restart_interaction()  # Force refresh of heart display
    
    $ met_clutch = True
    
    $ shuffle = False
    return


label clutch_romance_1:

    scene bg airport_lobby_furry
    
    "Your shift is winding down, and you find yourself thinking about the maintenance hangar."
    
    "As you pass by the coffee shop, you remember Clutch's comment about the 'watered-down stuff they serve passengers.'"

    menu:
        "The coffee shop is still open, and the aroma of freshly ground beans wafts through the air."
        "Buy a pour-over coffee for Clutch (-500 Miles)" if mc.miles >= 500:
            $ brought_coffee = True
            $ mc.miles -= 500
            "You order a pour-over of the good stuff. Single Origin dark roast, freshly ground. The barista takes their time, and you watch the careful process."
            "Armed with the large cup of quality coffee, you head toward the maintenance hangar."
            
        "Walk past the coffee shop without stopping":
            $ brought_coffee = False
            "You walk past the coffee shop, deciding to just drop by and see what he's up to. No need for bribes."
            
    scene bg hangar_night
    
    if brought_coffee:
        jump clutch_romance_coffee_path
    else:
        jump clutch_busy_no_time

label clutch_romance_coffee_path:
    $ shuffle = True
    "The hangar is alive with activity as you push through the familiar doors. You spot Clutch in his usual corner, bent over what looks like a turbine component."
    
    "The 'DO NOT CROSS' barrier is still prominently displayed, but you approach anyway, cup in hand."
    
    $ clutch.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "He must smell the coffee before he sees you, because his ears perk up and he spins around, nose twitching."
    
    clutch.character "Is that... actual coffee? Not the dishwater from the break room?"
    
    menu:
        "His eyes are locked on the cup in your hand with almost predatory focus."
        "Stride up to the barrier and hold out the cup confidently":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            "You stride up to the barrier and hold out the cup with confidence."
            mc.name "Pour-over from the coffee shop. Dark roast. Thought you could use something that actually tastes like coffee."
            clutch.character "You... actually paid attention. And did something about it."
            "He seems genuinely impressed by your initiative."
            
        "\"Found this lying around. Figured it beats whatever sludge you usually drink.\"":
            $ mc.humor += 1
            $ trait_used = "humor"
            mc.name "Found this lying around. Figured it beats whatever sludge you usually drink."
            "You hold out the cup with a casual shrug."
            clutch.character "Sure, 'found it.' Right."
            
        "\"I... I remembered what you said about coffee, so I thought maybe...\"":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            mc.name "I... I remembered what you said about coffee, so I thought maybe..."
            "You hold the cup out hesitantly."
            clutch.character "Well? You bringing it over here or not?"
            
        "Lean against the barrier while holding out the cup":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            "You lean against the barrier, holding out the cup with a suggestive smile."
            mc.name "I brought you something hot and dark... the coffee, I mean. Though I'm available too if you're interested."
            clutch.character "I... uh... let's start with the coffee."
            "His ears twitch slightly, and you notice a slight flush under his fur."
    
    # Add romance points based on trait used
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    "Clutch reaches across the barrier to take the cup, his movements quick and eager."
    
    "He takes a careful sip, and his whole demeanor changes. His tail does a little swish of approval."
    
    clutch.character "This is... actually good. Really good. Pour-over?"
    
    mc.name "Fresh ground, single origin. The barista said it was their best dark roast."
    
    "He takes another sip, savoring it, then looks at you with a new expression, something between surprise and respect."
    
    clutch.character "You know what? Get in here."
    
    "He gestures decisively for you to cross the barrier. Your eyes widen in surprise."
    
    mc.name "Seriously? But your rules..."
    
    clutch.character "Someone who brings me real coffee deserves to see real work. Come on, before I change my mind."
    
    if mc.assertiveness >= 20:
        mc.name "About time. I was starting to think that barrier was permanent."
        "You step over confidently, and he actually grins."
        clutch.character "Cocky. I like that. Just remember, you can be confident, but these tools still deserve respect."
        $ points_earned = add_romance_points(clutch, 2)  # Bonus for high assertiveness
    else:
        "You carefully step over the barrier, feeling like you're crossing into sacred territory."
    
    "Up close, you can see his workspace is organized chaos, tools grouped by some system only he understands."
    
    clutch.character "Working on an auxiliary power unit tonight. Everyone else would just replace it. Wasteful idiots."
    
    "He moves to the workbench where the complex machinery sits partially disassembled. His hands immediately start moving, touching different components as he talks."
    
    menu:
        "The intricate machinery gleams under his work lights, and you find yourself drawn to understand it."
        "\"APU failure? That's the backup power system, right? Critical for emergencies when the engines are off?\"":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            mc.name "APU failure? That's the backup power system, right? Critical for emergencies when the engines are off?"
            "His head snaps up, eyes wide with surprise."
            clutch.character "You... you actually know what an APU does?"
            mc.name "Of course I do. If that fails during an emergency, we lose cabin pressure control, lights, everything. Hopefully I never need one, but I'm glad to know it's there."
            "He looks at you with newfound respect, almost admiration."
            
        "Point at the machinery with nervous curiosity":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            "You point at the machinery with nervous curiosity."
            mc.name "Is it... is it okay if I ask what you're working on? I don't want to sound stupid..."
            clutch.character "It's an APU. And questions aren't stupid if you're genuinely trying to learn."
            
        "Scratch your head with exaggerated confusion":
            $ mc.humor += 1
            $ trait_used = "humor"
            "You scratch your head with exaggerated confusion."
            mc.name "I have no idea what that is, but I want to learn. Teach me, oh wise grease monkey."
            clutch.character "At least you're honest about it. And funny."
            
        "\"I love watching you work. The way your hands move with such precision... it's mesmerizing.\"":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            mc.name "I love watching you work. The way your hands move with such precision... it's mesmerizing."
            clutch.character "I, uh... thanks? Most people just see grease and tools."
            "He seems a bit flustered but pleased by the attention."
    
    # Add romance points based on trait used
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    clutch.character "Here, I'll show you something."
    
    "He picks up a precision tool and moves closer, but there's something different about his approach, like he's testing you."
    
    clutch.character "This is a torque driver. Specific pressure requirements. Think you can handle it?"
    
    if mc.assertiveness >= 25:
        mc.name "Hand it over. I'm a quick study."
        "You reach for the tool confidently, and he actually smiles as he passes it to you."
        clutch.character "Alright, hotshot. Let's see what you've got."
        $ points_earned = add_romance_points(clutch, 3)  # Big bonus for confidence
    else:
        mc.name "Show me the proper technique first."
        clutch.character "Smart. Knowing when to learn is important."
    
    "He moves behind you, guiding your hands to the correct grip. His presence is solid and sure."
    
    clutch.character "Feel the resistance in the mechanism? That tells you everything. Too much force and you're just another ham-fisted amateur."
    
    "His hands covered yours, adjusting your grip with practiced precision. Despite the grease and work, his touch is surprisingly gentle."
    
    clutch.character "There. Now turn it with steady pressure, don't force it."
    
    "As you work together, a drop of oil drips onto your uniform."
    
    menu:
        "The dark stain spreads slowly across the fabric of your uniform."
        "Keep working without a word. A little oil never hurt anyone.":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            "You keep working without a word, barely noticing the oil stain on your uniform."
            "He looks at you with approval."
            clutch.character "Damn. You get it. Work isn't supposed to be clean."
            
        "\"Oh no, my uniform...\"":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            mc.name "Oh no, my uniform..."
            "You look down at the spreading stain with dismay."
            clutch.character "Seriously? It's just oil. You'll survive."
            
        "Sniff the oil stain dramatically":
            $ mc.humor += 1
            $ trait_used = "humor"
            "You sniff the oil stain dramatically."
            mc.name "Great, now I'll smell like your hangar. The passengers will think I've gone rogue."
            "Without thinking, Clutch reaches to wipe it off, then catches himself."
            clutch.character "It's... it's a good smell. Honest work."
            
        "Run your finger through the oil and look at him suggestively":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            "You run your finger through the oil stain and look at him suggestively."
            mc.name "Mark me with your scent, why don't you? Now everyone will know I've been in your territory."
            "Clutch's eyes widen slightly, and his tail does an involuntary swish."
            clutch.character "That's... I mean... the oil isn't..."
            "He's clearly flustered by your directness."
    
    # Final romance points based on trait used
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)

    $ shuffle = False
    
    "You continue working together, and you notice he's stopped micromanaging your movements, trusting you more to do the job."
    
    clutch.character "You know, most of the flight crew treats me like I'm just the help. Some weird nocturnal creature who fixes their problems."
    
    "His voice carries a note of vulnerability despite his usual gruff demeanor."
    
    clutch.character "But you... you brought me real coffee. You're actually listening. You're not afraid to get your hands dirty."

    if clutch.romance >= 10:
        jump clutch_romance_reward_1

    else:
        pass
    
    "He steps back, but only slightly, still within your personal space."
    
    clutch.character "Listen, I've got to finish this tonight, but..."
    
    "He fidgets with a wrench, his usual nervous energy returning but mixed with something else."
    
    clutch.character "You could come back. When you have time. I could show you the really complex stuff... Systems most people never see."
    
    "He pauses, then adds with forced casualness:"
    
    clutch.character "And bring more of that coffee. It helps me focus."

    #Menu needs to replace this line    
    mc.name "I'll be back. Count on it."
    
    "As you step back over the barrier, he calls out:"
    
    clutch.character "Hey, [mc.name]? Thanks."
    
    $ clutch.hide(with_transition=dissolve)
    
    "You leave the hangar already planning your next visit."
    
    # Mark scene as completed
    $ mark_scene_completed(clutch, "clutch_romance_1")
    $ show_romance_notification(clutch)
    #$ show_romance_notification(clutch, f"Romance with Clutch increased! ({get_heart_level(clutch)} hearts)")
    
    #$ shuffle = False
    return

label clutch_busy_no_time:
    $ shuffle = True
    "You spot Clutch in his corner, completely absorbed in his work. The 'DO NOT CROSS' barrier seems more prominent than ever."
    
    $ clutch.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "You approach the barrier and clear your throat."
    
    mc.name "Hey Clutch, how's it going?"
    
    "He doesn't even look up from his work."
    
    clutch.character "Busy. Critical repair. Can't talk."
    
    "His tone is curt, focused. His hands move rapidly over the machinery."
    
    mc.name "Anything I can help with?"
    
    clutch.character "No. Go away. Some of us have real work to do."
    
    "He glances up briefly, and you notice his eyes narrow slightly."
    
    clutch.character "Next time bring coffee if you want to chat. Good coffee. Otherwise, don't bother me during critical repairs."
    
    $ clutch.hide(with_transition=dissolve)
    
    "Message received. You leave him to his work, making a mental note about the coffee."
    
    # Mark as attempted but no points earned
    #$ mark_scene_completed(clutch, "clutch_romance_1")
    #$ show_romance_notification(clutch, "No progress made. Try bringing coffee next time!")
    
    $ shuffle = False
    return



label clutch_threshold_bridge_1:
    scene bg hangar_night
    
    $ clutch.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "As you approach the barrier, Clutch looks up from his work and sets down his tools immediately."
    
    clutch.character "You again. Good."
    
    "He walks to the barrier, wiping his hands on a rag, that same intense look from before in his eyes."
    
    # Mark bridge scene as completed
    $ mark_scene_completed(clutch, "clutch_threshold_bridge_1")
    
    jump clutch_romance_reward_1



label clutch_romance_reward_1:
    # This works whether coming from main scene or bridge
    
    "He steps back slightly, but stays close. There's something different in his expression now."
    
    clutch.character "Listen, I need to finish this tonight, but..."
    
    "He fidgets with a wrench, his usual nervous energy mixing with something softer."
    
    clutch.character "You could come back. When you have time. I could show you the really complex stuff. Systems most people never see."
    
    "Before you can respond, he reaches out and takes your hand in his, his grip firm but gentle."
    
    if "clutch_threshold_bridge_1" not in clutch.scenes_completed:
        # They came straight from the main scene, reference the oil
        clutch.character "You did good tonight. Really good."
        "His thumb brushes over your palm, tracing the faint oil stains left from earlier."
    else:
        # They got here via the bridge scene (catch-ups)
        clutch.character "You've been good to me. Really good."
        "His thumb brushes over your palm, the touch surprisingly tender from someone usually so guarded."
    
    "The moment stretches between you before he seems to realize what he's doing and starts to let go."
    
    menu:
        "He's beginning to pull away, but there's a vulnerability in his eyes."
        
        "Pull him into a brief hug":
            $ mc.assertiveness += 1
            "Before he can fully retreat, you step forward and pull him into a quick embrace."
            "He stiffens for just a moment, then relaxes against you. His arms come up tentatively to return the hug."
            clutch.character "I... wasn't expecting that."
            "His voice is muffled against your shoulder, but you can hear the smile in it."
            "When you pull back, his ears are slightly pink, but he's looking at you with unmistakable warmth."
            
        "Let him pull away naturally":
            "You let him step back, respecting his space."
            "He clears his throat, looking almost disappointed that the moment has passed."
            
        "Squeeze his hand before letting go":
            $ mc.flirtiness += 1
            "You give his hand a gentle squeeze before he can pull away completely."
            "He looks down at your joined hands, then back up at you with a soft expression."
            clutch.character "Yeah... okay. I get it."
    
    clutch.character "And bring more of that coffee. It... helps me focus."
    
    "There's a new softness in his voice when he says it, like it's not really about the coffee anymore."
    
    # Mark reward scene as completed
    $ mark_scene_completed(clutch, "clutch_romance_reward_1")
    $ mark_scene_completed(clutch, "clutch_threshold_bridge_1")  # Mark bridge as seen if they came through it
    $ show_romance_notification(clutch)
    $ clutch.hearts += 1
    $ renpy.restart_interaction()  # Force refresh of heart display
    
    $ clutch.hide(with_transition=dissolve)
    
    "You leave the hangar feeling like something fundamental has shifted between you."
    
    return


label clutch_romance_2:
    $ shuffle = True
    scene bg hangar_night
    
    "It's been a few nights since your last meaningful interaction with Clutch. Tonight, the hangar feels different, quieter, more tense."
    
    "You find Clutch hunched over his workbench, surrounded by scattered parts. His usual organized chaos looks more chaotic than organized."
    
    $ clutch.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "As you approach, you notice his tail is bristled, ears flat. Something's wrong."
    
    mc.name "Clutch? Everything okay?"
    
    "He doesn't look up immediately, his hands moving frantically over a complex assembly."
    
    clutch.character "No. Everything is not okay. This APU controller is shot, and the replacement they sent is the wrong model."
    
    "His voice carries an edge of panic you've never heard before."
    
    clutch.character "Flight leaves at 6 AM. If I can't fix this original unit..."
    
    menu:
        "He trails off, hands shaking slightly as he attempts a delicate solder connection."
        
        "Step across the barrier uninvited and move to his side":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            "Without asking permission, you step across the barrier and move directly to his side."
            mc.name "Show me what needs doing. Two sets of hands are better than one, especially if one set isn't shaking."
            "He looks up sharply, about to protest, then sees the determination in your eyes."
            clutch.character "You... okay. Fine. Here, hold this steady."
            
        "\"Can I help? Please, just tell me what you need.\"":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            mc.name "Can I help? Please, just tell me what you need."
            clutch.character "I need a miracle, not sympathy."
            "His tone is sharp, stress making him snappy."
            
        "\"Hey, panicking won't unsolder that connection. Take a breath, grease monkey.\"":
            $ mc.humor += 1
            $ trait_used = "humor"
            mc.name "Hey, panicking won't unsolder that connection. Take a breath, grease monkey."
            "He actually pauses, then lets out a shaky laugh."
            clutch.character "Right. Right. Breathing. I can do that."
            
        "Move closer and gently place your hand over his trembling one":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            "You move closer and gently place your hand over his trembling one."
            mc.name "Your hands need to be steady for this. Let me help calm you down."
            clutch.character "This isn't the time for... whatever you're doing."
            "But he doesn't pull away."
    
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    "He takes a deep breath and refocuses on the component."
    
    clutch.character "The control board has a blown capacitor. I need to replace it, but the spacing is so tight..."
    
    "He gestures to a microscopic component that would require surgeon-like precision to replace."
    
    clutch.character "One wrong move and I fry the whole board. Then the plane doesn't fly, and guess who gets blamed?"
    
    menu:
        "His vulnerability is showing through the cracks in his usual gruff exterior."
        
        "\"You're the best mechanic here. If anyone can do this, it's you. I'll be your anchor.\"":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            mc.name "You're the best mechanic here. If anyone can do this, it's you. I'll be your anchor."
            "You stand behind him, hands on his shoulders, grounding him."
            clutch.character "I... yes. Okay. Anchor. I can work with that."
            "His breathing steadies under your touch."
            
        "\"What if... what if you can't fix it?\"":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            mc.name "What if... what if you can't fix it?"
            clutch.character "Then I've failed. Again."
            "The defeat in his voice is crushing."
            
        "\"So we'll tell them the plane needed a spa day. Gave the plane a day off.\"":
            $ mc.humor += 1
            $ trait_used = "humor"
            mc.name "So we'll tell them the plane needed a spa day. Gave the plane a day off."
            "Despite everything, he snorts."
            clutch.character "You're ridiculous. But... thanks."
            
        "Run your fingers through the fur at the back of his neck":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            "You run your fingers through the fur at the back of his neck, trying to soothe him."
            mc.name "You're so tense. Let me help you relax first."
            clutch.character "I don't have time to relax!"
            "But he leans into the touch briefly."
    
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    "With renewed focus, Clutch picks up his finest soldering iron."
    
    clutch.character "I'm going to tell you something, and if you repeat it, I'll deny it."
    
    "His voice drops to barely above a whisper."
    
    clutch.character "I wasn't always a mechanic. I was supposed to be an engineer. Aerospace. Had a scholarship and everything."
    
    "His hands move with practiced precision as he talks, like the confession is helping steady them."
    
    clutch.character "But I couldn't handle the pressure. The deadlines, the presentations, all those people watching and judging..."
    
    "The soldering iron hovers over the tiny capacitor."
    
    clutch.character "So I dropped out. Became a mechanic instead. My family still doesn't talk to me."
    
    menu:
        "This is the most vulnerable he's ever been with you."
        
        "\"You didn't fail. You found where you belong. This hangar would fall apart without you.\"":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            mc.name "You didn't fail. You found where you belong. This hangar would fall apart without you."
            "Your voice is firm, certain."
            mc.name "Engineering's loss is our gain. You're exactly where you should be."
            "His hand steadies completely, and he makes the first connection perfectly."
            clutch.character "You really think that?"
            
        "\"I'm sorry your family doesn't understand...\"":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            mc.name "I'm sorry your family doesn't understand..."
            clutch.character "Don't pity me. I made my choice."
            "His tone hardens again."
            
        "\"Their loss. More Clutch for the rest of us.\"":
            $ mc.humor += 1
            $ trait_used = "humor"
            mc.name "Their loss. More Clutch for the rest of us."
            "He actually smiles, just slightly."
            clutch.character "You're weird. But in a good way."
            
        "\"You're brilliant and dedicated. Anyone who can't see that doesn't deserve you.\"":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            mc.name "You're brilliant and dedicated. Anyone who can't see that doesn't deserve you."
            clutch.character "That's... that's nice of you to say."
            "He seems uncertain how to handle the compliment."
    
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    "With painstaking care, Clutch completes the solder connections. The board is repaired, but now comes the real test."
    
    clutch.character "Moment of truth."
    
    "He connects the board to his testing equipment. Lights flicker... then steady green across the board."
    
    clutch.character "It works! Holy shit, it actually works!"
    
    "In his excitement, he spins around and grabs you in a fierce hug, nearly lifting you off the ground."
    
    menu:
        "He's holding you tight, his relief and joy palpable."
        
        "Hug him back just as fiercely":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            "You wrap your arms around him and squeeze back just as hard."
            mc.name "I knew you could do it. Never doubted you for a second."
            "When he sets you down, you stay close, hands on his arms."
            clutch.character "You really didn't, did you? Even when I was falling apart."
            
        "Freeze up in surprise at the sudden contact":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            "You freeze up completely, overwhelmed by the sudden contact."
            mc.name "Oh! Um... you're... hugging me..."
            clutch.character "Shit, sorry. Got carried away."
            "He sets you down and steps back, the moment broken."
            
        "\"Careful there, or I'll start breaking things just to see you this happy.\"":
            $ mc.humor += 1
            $ trait_used = "humor"
            mc.name "Careful there, or I'll start breaking things just to see you this happy."
            "He laughs, setting you down but keeping his hands on your waist."
            clutch.character "Don't you dare. But... this is nice."
            
        "Hug him back, letting your hands drift lower":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            "You you hug him back, letting your hands drift lower."
            mc.name "If this is how you celebrate, I'll help you with repairs more often."
            clutch.character "Whoa, okay, that's... unexpected."
            "He lets go quickly, flustered."
    
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    "As the adrenaline fades, you're both suddenly aware of how close you're standing."
    
    clutch.character "You stayed. Even when I was a mess. Even when I snapped at you."
    
    "His hand comes up to cup your cheek, thumb brushing across your cheekbone."
    
    clutch.character "No one's ever done that before. They usually just leave when I get like that."
    
    menu:
        "The moment hangs between you, charged with possibility."
        
        "\"I'm not going anywhere. You're stuck with me now.\"":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            mc.name "I'm not going anywhere. You're stuck with me now."
            "You lean into his touch, maintaining eye contact."
            clutch.character "Promise?"
            "The word comes out so soft, so vulnerable."
            mc.name "Promise."
            
        "\"I just wanted to help...\"":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            mc.name "I just wanted to help..."
            "You look down, unable to meet his intense gaze."
            clutch.character "You did. More than you know."
            
        "\"Well, someone has to keep you functional. The airport needs its genius mechanic.\"":
            $ mc.humor += 1
            $ trait_used = "humor"
            mc.name "Well, someone has to keep you functional. The airport needs its genius mechanic."
            clutch.character "Just the airport?"
            "There's something playful in his tone now."
            
        "Turn your head to kiss his palm":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            "You turn your head to press a soft kiss to his palm."
            mc.name "I'll always stay when you need me."
            clutch.character "That's... I..."
            "He seems lost for words."
    
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    $ shuffle = False
    
    # Check if player has reached the threshold
    if clutch.romance >= 21:
        jump clutch_romance_reward_2
    else:
        # Player didn't earn enough points
        "He pulls back slightly, but the warmth in his eyes remains."
        
        clutch.character "I should install this board before something else goes wrong."
        
        "The moment passes, but something has definitely shifted between you."
        
        clutch.character "Thank you. For everything tonight. I... I'm glad you were here."
        
        mc.name "Anytime, Clutch."
        
        $ clutch.hide(with_transition=dissolve)
        
        "You leave him to his work, already planning your next visit."
    
    # Mark scene as completed
    $ mark_scene_completed(clutch, "clutch_romance_2")
    $ show_romance_notification(clutch)
    
    return


label clutch_threshold_bridge_2:
    scene bg hangar_night
    
    $ clutch.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "As you enter the hangar, Clutch immediately looks up from his work, his entire demeanor changing."
    
    clutch.character "[mc.name]! Perfect timing. Come here."
    
    "There's an intensity in his voice that makes you move quickly to his workspace."
    
    clutch.character "I've been thinking... about the other night. About you."
    
    # Mark bridge scene as completed
    $ mark_scene_completed(clutch, "clutch_threshold_bridge_2")
    
    jump clutch_romance_reward_2


label clutch_romance_reward_2:
    # This works whether coming from main scene or bridge
    
    "He moves closer, that nervous energy of his transformed into something more focused, more intentional."
    
    if "clutch_threshold_bridge_2" not in clutch.scenes_completed:
        # They came straight from the main scene
        clutch.character "You saw me at my worst tonight. And you didn't run."
    else:
        # They got here via the bridge scene
        clutch.character "You keep coming back. Even when I'm difficult. Even when I push people away."
    
    "His hand comes up to cup your face again, more confident this time."
    
    clutch.character "I'm not good at this. At letting people in. But with you..."
    
    "He leans in slowly, giving you time to pull away if you want. You don't."
    
    "His lips meet yours in a kiss that starts tentative, then grows more certain as you respond. His other hand comes up to frame your face, holding you like you're something precious."
    
    "When he pulls back, his eyes are bright, ears slightly pink."
    
    clutch.character "I've wanted to do that for a while now."
    
    menu:
        "He's still holding your face gently."
        
        "Pull him in for another kiss":
            $ mc.assertiveness += 1
            "You pull him back in, kissing him with more passion this time."
            "He makes a surprised sound that turns into something pleased, his arms wrapping around you properly."
            
        "Rest your forehead against his":
            "You lean forward, resting your forehead against his in a tender moment."
            clutch.character "Yeah. This is good. Really good."
            
        "\"Just a while? I've been waiting since I first brought you coffee.\"":
            $ mc.humor += 1
            mc.name "Just a while? I've been waiting since I first brought you coffee."
            "He laughs, pulling you closer."
            clutch.character "Should've said something sooner then."
    
    clutch.character "Will you... can you stay a bit longer? I want to show you something."
    
    "He leads you to a corner of his workspace you've never seen, pulling back a tarp to reveal a small propeller plane, the engine completely disassembled."
    
    clutch.character "I found this beauty in the scrapyard. I've been working on it for a while. It's... special to me."
    
    "The fact that he's sharing this with you feels more intimate than the kiss somehow."

    clutch.character "I think I can get it to fly again. I just need to finish it. When I do would you maybe like to take a ride with me?"

    menu:
        clutch.character "When I do would you maybe like to take a ride with me?"
        
        "\"I'd fly anywhere with you, Clutch.\"":
            "You meet his eyes, steady and sure."
            mc.name "I'd fly anywhere with you, Clutch. Just name the day."
            "His eyes light up at your certainty, tail swishing with barely contained excitement."
            clutch.character "Yeah? You mean that?"
            "You nod firmly, and he pulls you close again, grease-stained hands gentle despite their strength."
            $ mc.confidence += 1
        
        "\"If... if you really want me there...\"":
            "You duck your head slightly, feeling warmth spread through your chest."
            mc.name "If... if you really want me there, I'd love to."
            "He tilts your chin up with one finger, making you meet his gaze."
            clutch.character "Hey. I wouldn't ask if I didn't want you there."
            "The sincerity in his voice makes your knees weak."
            $ mc.submissiveness += 1
        
        "\"Only if you promise not to take it apart mid-flight.\"":
            mc.name "Only if you promise not to take the engine apart mid-flight to show me how it works."
            "He barks out a laugh, the sound genuine and warm."
            clutch.character "No promises. But I'll at least wait until we're on the ground."
            "You both grin at each other like idiots, the moment light but no less meaningful."
            $ mc.humor += 1
        
        "Step closer and trace your finger along his chest":
            "You step closer, running a finger along his chest."
            mc.name "Just the two of us, up in the clouds? How could I say no to that?"
            "Your voice drops to something more intimate."
            mc.name "Though I hope flying isn't the only thing we'll be doing up there..."
            "His breath catches, and he grabs your wandering hand, bringing it to his lips."
            clutch.character "Keep talking like that and we won't even make it off the ground."
            $ mc.flirtiness += 1
    
    "Clutch carefully covers the propeller plane back up with the tarp, and turns to you."
    clutch.character "You're special to me too, you know. In case that wasn't obvious."
    
    # Mark reward scene as completed
    $ mark_scene_completed(clutch, "clutch_romance_reward_2")
    $ show_romance_notification(clutch)
    $ clutch.hearts += 1
    $ renpy.restart_interaction()
    
    $ clutch.hide(with_transition=dissolve)
    
    "You spend another hour with him, learning about his past, his dreams, and stealing a few more kisses when he gets distracted explaining something particularly technical."
    
    "When you finally leave, you're both grinning like idiots."
    
    return



# Placeholder for clutch_romance_2 (Demo version)
label clutch_romance_3:
    scene bg hangar_night
    
    # Dev message

    
    
    "Jayden OverWood - Developer" "Congratulations on progressing so far with Clutch's romance path!"
    
    "Jayden OverWood - Developer" "You've really taken the time to understand this gruff mechanic's heart, and he's starting to open up to you in ways he never expected."
    
    "Jayden OverWood - Developer" "We're thrilled you're enjoying Clutch's story, and we can't wait for you to experience the rest of his romance scenes in the full release."
    
    "Jayden OverWood - Developer" "There's so much more to discover about this complex raccoon. His past, his dreams, and maybe even what's hidden under all that grease and attitude."
    
    "Now let's continue on!"
    
    # Intentionally NOT marking this scene as completed so it can be replayed if the player somehow gets here again
    
    return


# Hangar Catch-up 1: Coffee Delivery
label clutch_catchup_1:
    scene bg hangar_night
    
    $ clutch.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "Clutch is elbow-deep in an engine component when you approach with a steaming cup of nice coffee."
    
    mc.name "Brought you that coffee you mentioned. Dark roast, no sugar."
    
    "He extracts himself from the machinery, eyes lighting up."
    
    clutch.character "You remembered how I take it."
    
    menu:
        "He reaches for the cup eagerly."
        
        "\"Of course I did. Details matter, right?\"":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            mc.name "Of course I did. Details matter, right?"
            clutch.character "Exactly. You're learning."
            "He takes a long sip and nods approvingly."
            
        "\"I wrote it down so I wouldn't forget...\"":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            mc.name "I wrote it down so I wouldn't forget..."
            clutch.character "Seriously? It's just coffee."
            "He seems unimpressed by your nervousness."
            
        "\"I'm like a coffee stalker. I know everyone's order.\"":
            $ mc.humor += 1
            $ trait_used = "humor"
            mc.name "I'm like a coffee stalker. I know everyone's order."
            clutch.character "Creepy. But useful."
            "He smirks and takes the coffee."
            
        "\"I pay attention to what you like. All of it.\"":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            mc.name "I pay attention to what you like. All of it."
            clutch.character "That's... good to know, I guess."
            "He shifts uncomfortably but accepts the coffee."
    
    # Calculate catch-up points based on trait used
    # Catch-up scenes just use standard trait points
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    clutch.character "Thanks. Now let me work."
    
    $ clutch.hide(with_transition=dissolve)
    
    # Mark scene as completed
    $ mark_scene_completed(clutch, "clutch_catchup_1")
    #$ show_romance_notification(clutch, f"Romance increased! (+{points_earned} points)")
    
    return

# Hangar Catch-up 2: Mechanical Sound Report
label clutch_catchup_2:
    scene bg hangar_night
    
    $ clutch.show(at_list=[Transform(zoom=0.8, xpos=0.5, ypos=0.6, xanchor=0.5, yanchor=0.5)], with_transition=dissolve)
    
    "You find Clutch organizing his tools when you arrive."
    
    mc.name "Hey, remember you asked about weird sounds? Heard something on flight 447 today."
    
    "His ears perk up immediately."
    
    clutch.character "Tell me exactly what you heard."
    
    menu:
        "He's giving you his full attention."
        
        "\"Rhythmic clicking, every 3 seconds, during climb. Left side, row 12.\"":
            $ mc.assertiveness += 1
            $ trait_used = "assertiveness"
            mc.name "Rhythmic clicking, every 3 seconds, during climb. Left side, around row 12."
            clutch.character "That's exactly what I needed. Probably related to the pressurization system."
            "He looks genuinely impressed."
            clutch.character "You'd make a decent mechanic."
            
        "\"It was like... click-click? From somewhere in the middle?\"":
            $ mc.submissiveness += 1
            $ trait_used = "submissiveness"
            mc.name "It was like... click-click? From somewhere in the middle?"
            clutch.character "That tells me nothing. Be specific or don't bother."
            "He shakes his head in disappointment."
            
        "\"The plane was beatboxing. Pretty sick beat actually.\"":
            $ mc.humor += 1
            $ trait_used = "humor"
            mc.name "The plane was beatboxing. Pretty sick beat actually."
            clutch.character "Hilarious. The comedy club is that way."
            "Despite his sarcasm, you catch a slight smile."
            
        "\"I recorded it on my phone. Want to listen together?\"":
            $ mc.flirtiness += 1
            $ trait_used = "flirtiness"
            mc.name "I recorded it on my phone. Want to listen together?"
            clutch.character "Just... send me the file. I don't need company to diagnose sounds."
            "He seems confused by the suggestion."
    
    # Calculate catch-up points based on trait used
    # Catch-up scenes just use standard trait points
    $ points_earned = add_romance_points(clutch, trait_used=trait_used)
    
    $ clutch.hide(with_transition=dissolve)
    
    # Mark scene as completed
    $ mark_scene_completed(clutch, "clutch_catchup_2")
    #$ show_romance_notification(clutch, f"Romance increased! (+{points_earned} points)")
    
    return

# Scene for when visiting hangar during morning/day when Clutch isn't available
label clutch_not_here:
    scene bg hangar
    
    "The maintenance hangar buzzes with daytime activity. Mechanics move between aircraft with practiced efficiency, the clang of metal on metal echoing through the space."
    
    "You head toward Clutch's corner, but his workspace sits empty. The 'DO NOT CROSS' barrier is still there, tools arranged with obsessive precision on the benches beyond it."
    
    "A hippo mechanic notices you looking."
    
    "Mechanic Hippo" "Looking for Clutch? Wrong time, friend. He won't roll in until after sunset."
    
    "He wipes his hands on an already filthy rag."
    
    "Mechanic Hippo" "Nocturnal types, you know? Completely useless during daylight hours. I saw him try to work a morning shift once. Dropped a wrench on his foot and fell asleep standing up."
    
    "You glance back at his workspace. A coffee cup sits on the edge of his toolbox, the dregs long since cold."
    
    mc.name "When does he usually show up?"
    
    "Mechanic Hippo" "Eight, nine at night? Depends on the season. Earlier when the days are short."
    
    "He leans in conspiratorially."
    
    "Mechanic Hippo" "Word of advice? Bring decent coffee if you want him to talk. He's very particular about that. None of the break room garbage. Needs to be the good stuff."
    
    "Another mechanic calls him over to help with a hydraulic line. He gives you a quick nod before heading off."
    
    "You take one more look at Clutch's empty corner. Even abandoned, his workspace has a certain character. Everything placed in a particular order, waiting for its owner's return."
    
    "No point hanging around. You'll have to come back after dark if you want to catch him."

    show bg lounge_shower with fade
    
    "Back in the lounge you quickly take a shower in the communal showers. Luckily, or unluckily, it is empty this time."

    "You quickly towel off and grab your uniform from your locker."
    
    return