# Skill notification screen and related functions

init python:
    def show_skill_notification(improvements):
        """
        Show a notification for skills that have increased
        
        Args:
            improvements: Dictionary of skill names and increase amounts from process_encounter
        """
        if not improvements:  # If no improvements, don't show anything
            return
            
        # Simply show the screen with a timer, don't pause the game
        renpy.show_screen("skill_increase_notification", improvements=improvements)
        # No pause here - dialogue can continue
        
    def show_romance_notification(npc):
        """
        Show a notification for romance level increase with an NPC
        
        Args:
            npc: The NPC object whose romance level increased
        """
        # Simply show the screen with a timer, don't pause the game
        renpy.show_screen("romance_increase_notification", npc=npc)
        # No pause here - dialogue can continue

# Screen for skill increase notification
screen skill_increase_notification(improvements):
    zorder 100  # Make sure it appears above other elements
    
    # Set up a timer to automatically hide after 5 seconds
    timer 5.0 action Hide("skill_increase_notification")
    
    # Position in top-center to avoid overlapping dialogue
    frame:
        xalign 0.5   # Center horizontally
        yalign 0.09  # Lowered by ~20px from previous 0.05
        xpadding 30
        ypadding 15
        background "#222222AA"  # Semi-transparent dark gray to match top bar
        
        vbox:
            spacing 15
            xalign 0.5
            yalign 0.5
            
            text "Skills Improved!" size 28 xalign 0.5 color "#ffffff" font "gui/CreteRound-Regular.ttf"
            
            # Display each skill improvement
            for skill_name, amount in improvements.items():
                $ display_name = skill_name.replace("_", " ").title()  # Convert oral_skill to "Oral Skill"
                
                hbox:
                    spacing 10
                    text "[display_name]" color "#ffffff" size 24 font "gui/CreteRound-Regular.ttf"
                    text "Increased!" color "#aaffaa" size 24 font "gui/CreteRound-Regular.ttf"  # Light green matches status bar 

# Screen for romance increase notification
screen romance_increase_notification(npc):
    zorder 100  # Make sure it appears above other elements
    
    # Set up a timer to automatically hide after 5 seconds
    timer 5.0 action Hide("romance_increase_notification")
    
    # Position in top-center to avoid overlapping dialogue
    frame:
        xalign 0.5   # Center horizontally
        yalign 0.09  # Lowered by ~20px from previous 0.05
        xpadding 30
        ypadding 15
        background "#222222AA"  # Semi-transparent dark gray to match top bar
        
        vbox:
            spacing 15
            xalign 0.5
            yalign 0.5
            
            text "Relationship Improved!" size 28 xalign 0.5 color "#ffffff" font "gui/CreteRound-Regular.ttf"
            
            hbox:
                spacing 10
                text "Relationship with [npc.character.name]" color "#ffffff" size 24 font "gui/CreteRound-Regular.ttf"
                text "Increased!" color "#ffaaaa" size 24 font "gui/CreteRound-Regular.ttf"  # Light red for romance 